/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import java.util.Date;
import java.util.Hashtable;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.SerialNumberVersion;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.FieldMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.IntegerPrimaryKey;
import org.nakedobjects.plugins.sql.objectstore.PrimaryKey;
import org.nakedobjects.plugins.sql.objectstore.PrimaryKeyMapper;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.SqlOid;

public abstract class AbstractMapper {
    private FieldMappingLookup objectMapperLookup;
    private Hashtable keyMapping = new Hashtable();

    public abstract void createTables(DatabaseConnector var1);

    protected boolean needsTables(DatabaseConnector connector) {
        return false;
    }

    public final void shutdown() {
    }

    public void startup(DatabaseConnector connector, FieldMappingLookup objectMapperLookup) {
        this.objectMapperLookup = objectMapperLookup;
        if (this.needsTables(connector)) {
            this.createTables(connector);
        }
    }

    protected FieldMappingLookup getFieldMappingLookup() {
        return this.objectMapperLookup;
    }

    protected Oid recreateOid(Results rs, NakedObjectSpecification cls, String column) {
        PrimaryKey key;
        if (this.keyMapping.containsKey(column)) {
            key = ((PrimaryKeyMapper)this.keyMapping.get(column)).generateKey(rs, column);
        } else {
            Object object = rs.getObject(column);
            if (object == null) {
                return null;
            }
            int id = (Integer)object;
            key = new IntegerPrimaryKey(id);
        }
        SqlOid oid = new SqlOid(cls.getFullName(), key, SqlOid.State.PERSISTENT);
        return oid;
    }

    protected void addPrimaryKeyMapper(String columnName, PrimaryKeyMapper mapper) {
        this.keyMapping.put(columnName, mapper);
    }

    protected String asSqlName(String name) {
        return name.toUpperCase();
    }

    protected SerialNumberVersion createVersion(long versionSequence) {
        return new SerialNumberVersion(versionSequence, "", new Date());
    }
}

