/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnectorFactory;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStoreException;

public class DatabaseConnectorPool {
    private static final Logger LOG = Logger.getLogger(DatabaseConnectorPool.class);
    private static final int AVERAGE_POOL_SIZE = 5;
    private final DatabaseConnectorFactory factory;
    private final Vector connectorPool;

    public DatabaseConnectorPool(DatabaseConnectorFactory factory) {
        this(factory, 5);
    }

    public DatabaseConnectorPool(DatabaseConnectorFactory factory, int size) {
        this.factory = factory;
        this.connectorPool = new Vector();
        for (int i = 0; i < size; ++i) {
            this.newConnector();
        }
        LOG.info((Object)("Created an intial pool of " + size + " database connections"));
    }

    private DatabaseConnector newConnector() {
        DatabaseConnector connector = this.factory.createConnector();
        connector.setConnectionPool(this);
        this.connectorPool.addElement(connector);
        return connector;
    }

    public DatabaseConnector acquire() {
        DatabaseConnector connector = this.findFreeConnector();
        if (connector == null) {
            connector = this.newConnector();
            connector.setUsed(true);
            LOG.info((Object)("Added an additional database connection; now contains " + this.connectorPool.size() + " connections"));
        }
        LOG.debug((Object)("acquired connection " + connector));
        return connector;
    }

    private DatabaseConnector findFreeConnector() {
        int no = this.connectorPool.size();
        for (int i = 0; i < no; ++i) {
            DatabaseConnector connector = (DatabaseConnector)this.connectorPool.elementAt(i);
            if (connector.isUsed()) continue;
            connector.setUsed(true);
            return connector;
        }
        return null;
    }

    public void release(DatabaseConnector connector) {
        connector.setUsed(false);
        LOG.debug((Object)("released connection " + connector));
    }

    public void shutdown() {
        int no = this.connectorPool.size();
        for (int i = 0; i < no; ++i) {
            DatabaseConnector connector = (DatabaseConnector)this.connectorPool.elementAt(i);
            try {
                connector.close();
                continue;
            }
            catch (SqlObjectStoreException e) {
                LOG.error((Object)"Failed to release connectuion", (Throwable)((Object)e));
            }
        }
        this.connectorPool.removeAllElements();
    }
}

