/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.sql.objectstore.IdMapping;
import org.nakedobjects.plugins.sql.objectstore.VersionMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMappingFactory;
import org.nakedobjects.plugins.sql.objectstore.mapping.ObjectReferenceMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.ObjectReferenceMappingFactory;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class FieldMappingLookup {
    private static final Logger LOG = Logger.getLogger(FieldMappingLookup.class);
    private final Map<NakedObjectSpecification, FieldMappingFactory> fieldMappings = new HashMap<NakedObjectSpecification, FieldMappingFactory>();
    private final Map<NakedObjectSpecification, ObjectReferenceMappingFactory> referenceMappings = new HashMap<NakedObjectSpecification, ObjectReferenceMappingFactory>();
    private FieldMappingFactory referenceFieldMappingfactory;
    private ObjectReferenceMappingFactory objectReferenceMappingfactory;

    public FieldMapping createMapping(NakedObjectAssociation field) {
        NakedObjectSpecification spec = field.getSpecification();
        FieldMappingFactory factory = this.fieldMappings.get(spec);
        if (factory != null) {
            return factory.createFieldMapping(field);
        }
        if (spec.isEncodeable()) {
            throw new NotYetImplementedException();
        }
        factory = this.referenceFieldMappingfactory;
        this.addFieldMappingFactory(spec, factory);
        return factory.createFieldMapping(field);
    }

    public ObjectReferenceMapping createMapping(NakedObjectSpecification spec) {
        ObjectReferenceMappingFactory factory = this.referenceMappings.get(spec);
        if (factory != null) {
            return factory.createReferenceMapping(spec);
        }
        if (spec.isEncodeable()) {
            throw new NotYetImplementedException();
        }
        factory = this.objectReferenceMappingfactory;
        return factory.createReferenceMapping(spec);
    }

    public void addFieldMappingFactory(Class valueType, FieldMappingFactory mapper) {
        NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(valueType);
        this.addFieldMappingFactory(spec, mapper);
    }

    private void addFieldMappingFactory(NakedObjectSpecification specification, FieldMappingFactory mapper) {
        LOG.debug((Object)("add mapper " + mapper + " for " + specification));
        this.fieldMappings.put(specification, mapper);
    }

    public void addReferenceMappingFactory(NakedObjectSpecification specification, ObjectReferenceMappingFactory mapper) {
        LOG.debug((Object)("add mapper " + mapper + " for " + specification));
        this.referenceMappings.put(specification, mapper);
    }

    public void init() {
    }

    public IdMapping createIdMapping() {
        IdMapping idMapping = new IdMapping();
        idMapping.init();
        return idMapping;
    }

    public VersionMapping createVersionMapping() {
        VersionMapping versionMapping = new VersionMapping();
        versionMapping.init();
        return versionMapping;
    }

    public void setReferenceFieldMappingFactory(FieldMappingFactory referenceMappingfactory) {
        this.referenceFieldMappingfactory = referenceMappingfactory;
    }

    public void setObjectReferenceMappingfactory(ObjectReferenceMappingFactory objectReferenceMappingfactory) {
        this.objectReferenceMappingfactory = objectReferenceMappingfactory;
    }
}

