/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.sql.objectstore.IntegerPrimaryKey;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.SqlOid;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;

public class IdMappingAbstract {
    private String column;

    protected void setColumn(String column) {
        this.column = column;
    }

    protected String getColumn() {
        return this.column;
    }

    public void appendWhereClause(StringBuffer sql, NakedObject object) {
        this.appendWhereClause(sql, object.getOid());
    }

    public void appendWhereClause(StringBuffer sql, Oid oid) {
        sql.append(this.column);
        sql.append(" = ");
        String id = this.primaryKey(oid);
        sql.append(id);
    }

    public void appendColumnDefinitions(StringBuffer sql) {
        sql.append(this.column);
        sql.append(" ");
        sql.append("INT");
    }

    public void appendColumnNames(StringBuffer sql) {
        sql.append(this.column);
    }

    public void appendInsertValues(StringBuffer sql, NakedObject object) {
        if (object == null) {
            sql.append("NULL");
        } else {
            sql.append(this.primaryKey(object.getOid()));
        }
    }

    public String primaryKey(Oid oid) {
        return oid instanceof SqlOid ? ((SqlOid)oid).getPrimaryKey().stringValue() : "" + ((SerialOid)oid).getSerialNo();
    }

    public Oid recreateOid(Results rs, NakedObjectSpecification specification) {
        Object object = rs.getObject(this.column);
        if (object == null) {
            return null;
        }
        int id = (Integer)object;
        IntegerPrimaryKey key = new IntegerPrimaryKey(id);
        SqlOid oid = new SqlOid(specification.getFullName(), key, SqlOid.State.PERSISTENT);
        return oid;
    }

    protected NakedObject getAdapter(NakedObjectSpecification specification, Oid oid) {
        AdapterManager objectLoader = NakedObjectsContext.getPersistenceSession().getAdapterManager();
        NakedObject adapter = objectLoader.getAdapterFor(oid);
        if (adapter != null) {
            return adapter;
        }
        return NakedObjectsContext.getPersistenceSession().recreateAdapter(oid, specification);
    }
}

