/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationException;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnectorPool;
import org.nakedobjects.plugins.sql.objectstore.FieldMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.ObjectMapping;
import org.nakedobjects.plugins.sql.objectstore.ObjectMappingFactory;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStoreException;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;

public class ObjectMappingLookup {
    private static final Logger LOG = Logger.getLogger(ObjectMappingLookup.class);
    private DatabaseConnectorPool connectionPool;
    private final Map<NakedObjectSpecification, ObjectMapping> mappings = new HashMap<NakedObjectSpecification, ObjectMapping>();
    private ObjectMappingFactory objectMappingFactory;
    private FieldMappingLookup fieldMappingLookup;

    public ObjectMapping getMapping(NakedObjectSpecification spec) {
        ObjectMapping mapping = this.mappings.get(spec);
        if (mapping == null) {
            String propertiesBase = "nakedobjects.persistence.sql.automapper.default";
            mapping = this.objectMappingFactory.createMapper(spec.getFullName(), propertiesBase, this.fieldMappingLookup);
            this.add(spec, mapping);
        }
        LOG.debug((Object)("  mapper for " + spec.getSingularName() + " -> " + mapping));
        if (mapping == null) {
            throw new NakedObjectException("No mapper for " + spec + " (no default mapper)");
        }
        return mapping;
    }

    public ObjectMapping getMapping(NakedObject object) {
        return this.getMapping(object.getSpecification());
    }

    public void setConnectionPool(DatabaseConnectorPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void setObjectMappingFactory(ObjectMappingFactory mapperFactory) {
        this.objectMappingFactory = mapperFactory;
    }

    public void setValueMappingLookup(FieldMappingLookup fieldMappingLookup) {
        this.fieldMappingLookup = fieldMappingLookup;
    }

    private void add(String className, ObjectMapping mapper) {
        NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(className);
        if (spec.getPropertyList().size() == 0) {
            throw new SqlObjectStoreException(spec.getFullName() + " has no fields to persist: " + spec);
        }
        this.add(spec, mapper);
    }

    public void add(NakedObjectSpecification specification, ObjectMapping mapper) {
        LOG.debug((Object)("add mapper " + mapper + " for " + specification));
        DatabaseConnector connection = this.connectionPool.acquire();
        mapper.startup(connection, this);
        this.connectionPool.release(connection);
        this.mappings.put(specification, mapper);
    }

    public void init() {
        this.fieldMappingLookup.init();
        String prefix = "nakedobjects.persistence.sql.mapper.";
        NakedObjectConfiguration subset = NakedObjectsContext.getConfiguration().createSubset(prefix);
        Enumeration e = subset.propertyNames();
        while (e.hasMoreElements()) {
            String propertiesBase;
            String className = (String)e.nextElement();
            String value = subset.getString(className);
            if (value.startsWith("auto.")) {
                propertiesBase = "nakedobjects.persistence.sql.automapper." + value.substring(5) + ".";
                this.add(className, this.objectMappingFactory.createMapper(className, propertiesBase, this.fieldMappingLookup));
                continue;
            }
            if (value.trim().equals("auto")) {
                propertiesBase = "nakedobjects.persistence.sql.automapper.default";
                this.add(className, this.objectMappingFactory.createMapper(className, propertiesBase, this.fieldMappingLookup));
                continue;
            }
            LOG.debug((Object)("mapper " + className + "=" + value));
            try {
                this.add(className, (ObjectMapping)InstanceFactory.createInstance((String)value, ObjectMapping.class));
            }
            catch (ObjectPersistenceException ex) {
                throw new InstanceCreationException("Failed to set up mapper for " + className, (Throwable)ex);
            }
        }
    }

    public void shutdown() {
        for (ObjectMapping mapping : this.mappings.values()) {
            try {
                mapping.shutdown();
            }
            catch (ObjectPersistenceException ex) {
                LOG.error((Object)("Shutdown mapper " + mapping), (Throwable)ex);
            }
        }
    }
}

