/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnectorPool;
import org.nakedobjects.plugins.sql.objectstore.IntegerPrimaryKey;
import org.nakedobjects.plugins.sql.objectstore.ObjectMapping;
import org.nakedobjects.plugins.sql.objectstore.ObjectMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.SqlExecutionContext;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStoreException;
import org.nakedobjects.plugins.sql.objectstore.SqlOid;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindByPattern;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindByTitle;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.PersistenceCommand;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlObjectStore
implements ObjectStore {
    public static final String BASE_NAME = "nakedobjects.persistence.sql";
    private static final Logger LOG = Logger.getLogger(SqlObjectStore.class);
    private DatabaseConnectorPool connectionPool;
    private ObjectMappingLookup objectMappingLookup;
    private boolean isInitialized;

    public void abortTransaction() {
    }

    public CreateObjectCommand createCreateObjectCommand(final NakedObject object) {
        return new CreateObjectCommand(){

            public void execute(NakedObjectTransaction context) {
                DatabaseConnector connection = ((SqlExecutionContext)context).getConnection();
                LOG.debug((Object)("  create object " + object));
                ObjectMapping mapping = SqlObjectStore.this.objectMappingLookup.getMapping(object);
                mapping.createObject(connection, object);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "CreateObjectCommand [object=" + object + "]";
            }
        };
    }

    public DestroyObjectCommand createDestroyObjectCommand(final NakedObject object) {
        return new DestroyObjectCommand(){

            public void execute(NakedObjectTransaction context) {
                DatabaseConnector connection = ((SqlExecutionContext)context).getConnection();
                LOG.debug((Object)("  destroy object " + object));
                ObjectMapping mapping = SqlObjectStore.this.objectMappingLookup.getMapping(object);
                mapping.destroyObject(connection, object);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "DestroyObjectCommand [object=" + object + "]";
            }
        };
    }

    public SaveObjectCommand createSaveObjectCommand(final NakedObject object) {
        return new SaveObjectCommand(){

            public void execute(NakedObjectTransaction context) {
                DatabaseConnector connection = ((SqlExecutionContext)context).getConnection();
                LOG.debug((Object)("  save object " + object));
                if (object.getSpecification().isCollectionOrIsAggregated()) {
                    throw new NotYetImplementedException(object.toString());
                }
                ObjectMapping mapping = SqlObjectStore.this.objectMappingLookup.getMapping(object);
                mapping.save(connection, object);
                SqlObjectStore.this.connectionPool.release(connection);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "SaveObjectCommand [object=" + object + "]";
            }
        };
    }

    public void debugData(DebugString debug) {
    }

    public String debugTitle() {
        return null;
    }

    public void endTransaction() {
    }

    public void execute(List<PersistenceCommand> commands) {
        DatabaseConnector connector = this.connectionPool.acquire();
        connector.begin();
        NakedObjectTransactionManager transactionManager = NakedObjectsContext.getTransactionManager();
        MessageBroker messageBroker = NakedObjectsContext.getMessageBroker();
        UpdateNotifier updateNotifier = NakedObjectsContext.getUpdateNotifier();
        SqlExecutionContext context = new SqlExecutionContext(connector, transactionManager, messageBroker, updateNotifier);
        try {
            for (PersistenceCommand command : commands) {
                command.execute((NakedObjectTransaction)context);
            }
            connector.commit();
        }
        catch (NakedObjectException e) {
            LOG.warn((Object)"Failure during execution", (Throwable)e);
            connector.rollback();
            throw e;
        }
        finally {
            this.connectionPool.release(connector);
        }
    }

    public boolean flush(PersistenceCommand[] commands) {
        return false;
    }

    public NakedObject[] getInstances(PersistenceQuery query) {
        if (query instanceof PersistenceQueryFindByTitle) {
            return this.getInstancesForTitle((PersistenceQueryFindByTitle)query);
        }
        if (query instanceof PersistenceQueryFindAllInstances) {
            return this.getAllInstances((PersistenceQueryFindAllInstances)query);
        }
        if (query instanceof PersistenceQueryFindByPattern) {
            NakedObject[] allInstances = this.allInstances(query.getSpecification());
            Vector<NakedObject> matches = new Vector<NakedObject>();
            for (int i = 0; i < allInstances.length; ++i) {
                if (!((PersistenceQueryFindByPattern)query).matches(allInstances[i])) continue;
                matches.add(allInstances[i]);
            }
            NakedObject[] result = new NakedObject[matches.size()];
            matches.toArray(result);
            return result;
        }
        throw new SqlObjectStoreException("Query type not supported: " + query);
    }

    private NakedObject[] getAllInstances(PersistenceQueryFindAllInstances criteria) {
        NakedObjectSpecification spec = criteria.getSpecification();
        return this.allInstances(spec);
    }

    private NakedObject[] allInstances(NakedObjectSpecification spec) {
        ObjectMapping mapper = this.objectMappingLookup.getMapping(spec);
        DatabaseConnector connector = this.connectionPool.acquire();
        NakedObject[] instances = mapper.getInstances(connector, spec);
        Vector<NakedObject> matchingInstances = new Vector<NakedObject>();
        for (int i = 0; i < instances.length; ++i) {
            matchingInstances.addElement(instances[i]);
        }
        this.connectionPool.release(connector);
        Object[] instanceArray = new NakedObject[matchingInstances.size()];
        matchingInstances.copyInto(instanceArray);
        return instanceArray;
    }

    private NakedObject[] getInstancesForTitle(PersistenceQueryFindByTitle criteria) {
        NakedObjectSpecification spec = criteria.getSpecification();
        ObjectMapping mapper = this.objectMappingLookup.getMapping(spec);
        DatabaseConnector connector = this.connectionPool.acquire();
        NakedObject[] instances = mapper.getInstances(connector, spec);
        Vector<NakedObject> matchingInstances = new Vector<NakedObject>();
        for (int i = 0; i < instances.length; ++i) {
            if (!criteria.matches(instances[i])) continue;
            matchingInstances.addElement(instances[i]);
        }
        this.connectionPool.release(connector);
        Object[] instanceArray = new NakedObject[matchingInstances.size()];
        matchingInstances.copyInto(instanceArray);
        return instanceArray;
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) {
        ObjectMapping mapper = this.objectMappingLookup.getMapping(hint);
        DatabaseConnector connection = this.connectionPool.acquire();
        NakedObject object = mapper.getObject(connection, oid, hint);
        this.connectionPool.release(connection);
        return object;
    }

    public Oid getOidForService(String name) {
        DatabaseConnector connector = this.connectionPool.acquire();
        Results results = connector.select("select PK_ID from NO_SERVICES where ID = '" + name + "'");
        if (results.next()) {
            int key = results.getInt("PK_ID");
            this.connectionPool.release(connector);
            return SqlOid.createPersistent(name, new IntegerPrimaryKey(key));
        }
        this.connectionPool.release(connector);
        return null;
    }

    public boolean hasInstances(NakedObjectSpecification spec) {
        DatabaseConnector connection = this.connectionPool.acquire();
        ObjectMapping mapper = this.objectMappingLookup.getMapping(spec);
        boolean hasInstances = mapper.hasInstances(connection, spec);
        this.connectionPool.release(connection);
        return hasInstances;
    }

    public boolean isFixturesInstalled() {
        return this.isInitialized;
    }

    public void open() {
        this.objectMappingLookup.init();
        DatabaseConnector connector = this.connectionPool.acquire();
        this.isInitialized = connector.hasTable("NO_SERVICES");
        if (!this.isInitialized) {
            connector.update("create table NO_SERVICES (PK_ID int, ID varchar(255))");
        }
    }

    public String name() {
        return "SQL Object Store";
    }

    public void registerService(String name, Oid oid) {
        DatabaseConnector connector = this.connectionPool.acquire();
        String soid = ((SqlOid)oid).getPrimaryKey().stringValue();
        connector.insert("insert into NO_SERVICES (PK_ID, ID) values ( " + soid + ", '" + name + "')");
        this.connectionPool.release(connector);
    }

    public void reset() {
    }

    public void resolveField(NakedObject object, NakedObjectAssociation field) {
        if (field.isOneToManyAssociation()) {
            DatabaseConnector connection = this.connectionPool.acquire();
            NakedObjectSpecification spec = object.getSpecification();
            ObjectMapping mapper = this.objectMappingLookup.getMapping(spec);
            mapper.resolveCollection(connection, object, field);
            this.connectionPool.release(connection);
        } else {
            this.resolveImmediately(field.get(object));
        }
    }

    public void resolveImmediately(NakedObject object) {
        DatabaseConnector connector = this.connectionPool.acquire();
        ObjectMapping mapping = this.objectMappingLookup.getMapping(object);
        mapping.resolve(connector, object);
        this.connectionPool.release(connector);
    }

    public void setConnectionPool(DatabaseConnectorPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void setMapperLookup(ObjectMappingLookup mapperLookup) {
        this.objectMappingLookup = mapperLookup;
    }

    public void close() {
        this.objectMappingLookup.shutdown();
        this.connectionPool.shutdown();
    }

    public void startTransaction() {
    }
}

