/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import java.io.IOException;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.plugins.sql.objectstore.PrimaryKey;
import org.nakedobjects.plugins.sql.objectstore.TransientKey;

public final class SqlOid
implements Oid {
    private static final long serialVersionUID = 1L;
    private String className;
    private SqlOid previous;
    private PrimaryKey primaryKey;
    private PrimaryKey newPrimaryKey;
    private State state;

    public static SqlOid createPersistent(String className, PrimaryKey primaryKey) {
        return new SqlOid(className, primaryKey, State.PERSISTENT);
    }

    public static SqlOid createTransient(String className, long serialNo) {
        return new SqlOid(className, new TransientKey(serialNo), State.TRANSIENT);
    }

    public SqlOid(String className, PrimaryKey primaryKey, State state) {
        this.className = className;
        this.primaryKey = primaryKey;
        this.state = state;
        this.initialized();
    }

    public SqlOid(DataInputExtended input) throws IOException {
        this.className = input.readUTF();
        this.primaryKey = (PrimaryKey)input.readSerializable(PrimaryKey.class);
        this.newPrimaryKey = (PrimaryKey)input.readSerializable(PrimaryKey.class);
        this.previous = (SqlOid)input.readEncodable(SqlOid.class);
        this.state = (State)((Object)input.readSerializable(State.class));
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.className);
        output.writeSerializable((Object)this.primaryKey);
        output.writeSerializable((Object)this.newPrimaryKey);
        output.writeEncodable((Object)this.previous);
        output.writeSerializable((Object)this.state);
    }

    private void initialized() {
    }

    public void copyFrom(Oid oid) {
        Assert.assertTrue((boolean)(oid instanceof SqlOid));
        SqlOid from = (SqlOid)oid;
        this.primaryKey = from.primaryKey;
        this.className = from.className;
    }

    public String getClassName() {
        return this.className;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isTransient() {
        return this.primaryKey instanceof TransientKey;
    }

    public void setId(PrimaryKey primaryKey) {
        Assert.assertTrue((boolean)this.state.isTransient());
        this.newPrimaryKey = primaryKey;
    }

    public void makePersistent() {
        Assert.assertTrue((boolean)this.state.isTransient());
        Assert.assertNotNull((Object)this.newPrimaryKey);
        this.previous = new SqlOid(this.className, this.primaryKey, this.state);
        this.primaryKey = this.newPrimaryKey;
        this.state = State.PERSISTENT;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public Oid getPrevious() {
        return this.previous;
    }

    public void clearPrevious() {
        this.previous = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SqlOid) {
            SqlOid otherOid = (SqlOid)obj;
            return this.className.equals(otherOid.className) && this.primaryKey.equals(otherOid.primaryKey);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.className.hashCode();
        hashCode = 37 * hashCode + this.primaryKey.hashCode();
        return hashCode;
    }

    public String toString() {
        return (this.isTransient() ? "T" : "") + "OID#" + this.primaryKey.stringValue() + "/" + this.className + (this.previous == null ? "" : "+");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PERSISTENT,
        TRANSIENT;


        public boolean isTransient() {
            return this == TRANSIENT;
        }
    }
}

