/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnectorPool;
import org.nakedobjects.plugins.sql.objectstore.IntegerPrimaryKey;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStoreException;
import org.nakedobjects.plugins.sql.objectstore.SqlOid;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGeneratorAbstract;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;

public class SqlOidGenerator
extends OidGeneratorAbstract {
    private long number;
    private long transientNumber;
    private final DatabaseConnectorPool connectionPool;

    public SqlOidGenerator(DatabaseConnectorPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void open() {
        this.transientNumber = -9999999L;
        if (this.connectionPool != null) {
            DatabaseConnector db = this.connectionPool.acquire();
            try {
                db.begin();
                if (!db.hasTable("NO_SERIAL_ID")) {
                    db.update("create table NO_SERIAL_ID (NUMBER INTEGER)");
                    db.update("insert into NO_SERIAL_ID values (1)");
                }
                Results rs = db.select("select NUMBER from NO_SERIAL_ID");
                rs.next();
                this.number = rs.getLong("NUMBER");
                rs.close();
                db.commit();
            }
            catch (ObjectPersistenceException e) {
                db.rollback();
                throw e;
            }
            finally {
                this.connectionPool.release(db);
            }
        }
    }

    public String name() {
        return "Sql Oids";
    }

    public void close() {
        if (this.connectionPool != null) {
            DatabaseConnector db = this.connectionPool.acquire();
            try {
                db.begin();
                if (db.update("update NO_SERIAL_ID set NUMBER = " + this.number) != 1) {
                    throw new SqlObjectStoreException("failed to update serial id table; no rows updated");
                }
                db.commit();
            }
            catch (ObjectPersistenceException e) {
                throw e;
            }
            finally {
                if (db != null) {
                    this.connectionPool.release(db);
                }
            }
        }
    }

    public SqlOid createTransientOid(Object object) {
        String className = object.getClass().getName();
        return SqlOid.createTransient(className, this.transientNumber++);
    }

    public void convertTransientToPersistentOid(Oid oid) {
        Assert.assertNotNull((String)"No connection set up", (Object)this.connectionPool);
        IntegerPrimaryKey primaryKey = new IntegerPrimaryKey((int)this.number++);
        ((SqlOid)oid).setId(primaryKey);
        ((SqlOid)oid).makePersistent();
    }

    public void convertPersistentToTransientOid(Oid oid) {
    }

    public void debugData(DebugString debug) {
        debug.appendln(((Object)((Object)this)).toString());
        debug.indent();
        debug.appendln("id", this.number);
        debug.appendln("transient id", this.transientNumber);
        debug.unindent();
    }

    public String debugTitle() {
        return "SQL OID Generator";
    }
}

