/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnectorPool;
import org.nakedobjects.plugins.sql.objectstore.FieldMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.ObjectMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStore;
import org.nakedobjects.plugins.sql.objectstore.SqlOidGenerator;
import org.nakedobjects.plugins.sql.objectstore.SqlPersistenceSessionFactory;
import org.nakedobjects.plugins.sql.objectstore.auto.AutoMapperFactory;
import org.nakedobjects.plugins.sql.objectstore.jdbc.JdbcConnectorFactory;
import org.nakedobjects.plugins.sql.objectstore.jdbc.JdbcFieldMappingFactoryInstaller;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStorePersistenceMechanismInstallerAbstract;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.system.DeploymentType;

public class SqlPersistorInstaller
extends ObjectStorePersistenceMechanismInstallerAbstract {
    private SqlObjectStore objectStore;
    private DatabaseConnectorPool connectionPool;

    public SqlPersistorInstaller(String name) {
        super("sql");
        JdbcConnectorFactory connectorFactory = new JdbcConnectorFactory();
        this.connectionPool = new DatabaseConnectorPool(connectorFactory, 1);
    }

    protected ObjectStore createObjectStore(NakedObjectConfiguration configuration, AdapterFactory nakedObjectFactory, AdapterManager adapterManager) {
        if (this.objectStore == null) {
            FieldMappingLookup fieldMappingLookup = new FieldMappingLookup();
            JdbcFieldMappingFactoryInstaller installer = new JdbcFieldMappingFactoryInstaller();
            installer.load(fieldMappingLookup);
            ObjectMappingLookup objectMappingLookup = new ObjectMappingLookup();
            objectMappingLookup.setValueMappingLookup(fieldMappingLookup);
            objectMappingLookup.setObjectMappingFactory(new AutoMapperFactory());
            objectMappingLookup.setConnectionPool(this.connectionPool);
            SqlObjectStore objectStore = new SqlObjectStore();
            objectStore.setMapperLookup(objectMappingLookup);
            objectStore.setConnectionPool(this.connectionPool);
            this.objectStore = objectStore;
        }
        return this.objectStore;
    }

    protected OidGenerator createOidGenerator(NakedObjectConfiguration configuration) {
        return new SqlOidGenerator(this.connectionPool);
    }

    public PersistenceSessionFactory createPersistenceSessionFactory(DeploymentType deploymentType) {
        return new SqlPersistenceSessionFactory(deploymentType, this);
    }
}

