/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore;

import java.util.Date;
import org.nakedobjects.metamodel.adapter.version.SerialNumberVersion;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.Sql;

public class VersionMapping {
    private String lastActivityDateColumn;
    private String lastActivityUserColumn;
    private String versionColumn;

    public void init() {
        this.lastActivityDateColumn = "MODIFIED_ON";
        this.lastActivityUserColumn = "MODIFIED_BY";
        this.versionColumn = "VERSION";
    }

    public String insertColumns() {
        return this.versionColumn + ", " + this.lastActivityUserColumn + ", " + this.lastActivityDateColumn;
    }

    public String insertValues(SerialNumberVersion version) {
        return version.sequence() + ", '" + version.getUser() + "',  " + Sql.timestamp;
    }

    public String whereClause(SerialNumberVersion version) {
        return this.versionColumn + " = " + version.sequence();
    }

    public String updateAssigment(long nextSequence) {
        return this.versionColumn + " = " + nextSequence;
    }

    public String appendSelectColumns() {
        StringBuffer sql = new StringBuffer();
        sql.append(this.versionColumn);
        sql.append(",");
        sql.append(this.lastActivityUserColumn);
        sql.append(",");
        sql.append(this.lastActivityDateColumn);
        return sql.toString();
    }

    public String appendColumnDefinitions() {
        StringBuffer sql = new StringBuffer();
        sql.append(this.versionColumn);
        sql.append(" bigint");
        sql.append(",");
        sql.append(this.lastActivityUserColumn);
        sql.append(" varchar(32)");
        sql.append(",");
        sql.append(this.lastActivityDateColumn);
        sql.append(" timestamp");
        return sql.toString();
    }

    public Object appendUpdateValues(long versionSequence) {
        return this.versionColumn + "=" + versionSequence;
    }

    public Version getLock(Results rs) {
        long number = rs.getLong(this.versionColumn);
        String user = rs.getString(this.lastActivityUserColumn);
        Date time = rs.getDate(this.lastActivityDateColumn);
        SerialNumberVersion version = new SerialNumberVersion(number, user, time);
        return version;
    }
}

