/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.auto;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.SerialNumberVersion;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.sql.objectstore.AbstractMapper;
import org.nakedobjects.plugins.sql.objectstore.CollectionMapper;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.FieldMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStoreException;
import org.nakedobjects.plugins.sql.objectstore.auto.AutoCollectionMapper;
import org.nakedobjects.plugins.sql.objectstore.auto.ReversedAutoAssociationMapper;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMapping;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

public abstract class AbstractAutoMapper
extends AbstractMapper {
    private static final Logger LOG = Logger.getLogger(AbstractAutoMapper.class);
    protected CollectionMapper[] collectionMappers;
    protected boolean dbCreatesId;
    protected NakedObjectSpecification specification;
    protected String table;
    protected List<FieldMapping> fieldMappings = new ArrayList<FieldMapping>();

    protected AbstractAutoMapper(String nakedClassName, String parameterBase, FieldMappingLookup lookup) {
        this.specification = NakedObjectsContext.getSpecificationLoader().loadSpecification(nakedClassName);
        if (this.specification.getPropertyList() == null || this.specification.getPropertyList().size() == 0) {
            throw new SqlObjectStoreException(this.specification.getFullName() + " has no fields: " + this.specification);
        }
        this.setUpFieldMappers(lookup, nakedClassName, parameterBase);
    }

    private void setUpFieldMappers(FieldMappingLookup lookup, String nakedClassName, String parameterBase) {
        NakedObjectConfiguration configParameters = NakedObjectsContext.getConfiguration();
        this.table = configParameters.getString(parameterBase + "table");
        if (this.table == null) {
            this.table = this.asSqlName(nakedClassName.substring(nakedClassName.lastIndexOf(46) + 1).toUpperCase());
        }
        this.dbCreatesId = configParameters.getBoolean(parameterBase + "db-ids", false);
        if (configParameters.getBoolean(parameterBase + "all-fields", true)) {
            this.setupFullMapping(lookup, nakedClassName, configParameters, parameterBase);
        }
        LOG.info((Object)("table mapping: " + this.table + " (" + this.columnList() + ")"));
    }

    private void setupFullMapping(FieldMappingLookup lookup, String nakedClassName, NakedObjectConfiguration configParameters, String parameterBase) {
        List fields = this.specification.getAssociationList();
        int simpleFieldCount = 0;
        int collectionFieldCount = 0;
        for (int i = 0; i < fields.size(); ++i) {
            if (!((NakedObjectAssociation)fields.get(i)).isNotDerived()) continue;
            if (((NakedObjectAssociation)fields.get(i)).isOneToManyAssociation()) {
                ++collectionFieldCount;
                continue;
            }
            ++simpleFieldCount;
        }
        NakedObjectAssociation[] oneToOneProperties = new NakedObjectAssociation[simpleFieldCount];
        NakedObjectAssociation[] oneToManyProperties = new NakedObjectAssociation[collectionFieldCount];
        this.collectionMappers = new CollectionMapper[collectionFieldCount];
        NakedObjectConfiguration subset = NakedObjectsContext.getConfiguration().createSubset(parameterBase + ".mapper.");
        int simpleFieldNo = 0;
        int collectionFieldNo = 0;
        for (int i = 0; i < fields.size(); ++i) {
            NakedObjectAssociation field = (NakedObjectAssociation)fields.get(i);
            if (!field.isNotDerived()) continue;
            if (field.isOneToManyAssociation()) {
                oneToManyProperties[collectionFieldNo] = field;
                String type = subset.getString(field.getId());
                if (type == null || type.equals("association-table")) {
                    this.collectionMappers[collectionFieldNo] = new AutoCollectionMapper(this.specification, oneToManyProperties[collectionFieldNo], lookup);
                } else if (type.equals("fk-table")) {
                    String property = parameterBase + field.getId() + ".element-type";
                    String elementType = configParameters.getString(property);
                    if (elementType == null) {
                        throw new SqlObjectStoreException("Expected property " + property);
                    }
                    this.collectionMappers[collectionFieldNo] = new ReversedAutoAssociationMapper(elementType, oneToManyProperties[collectionFieldNo], parameterBase, lookup);
                } else {
                    throw new NotYetImplementedException("for " + type);
                }
                ++collectionFieldNo;
                continue;
            }
            if (field.isOneToOneAssociation()) {
                oneToOneProperties[simpleFieldNo] = field;
                ++simpleFieldNo;
                continue;
            }
            oneToOneProperties[simpleFieldNo] = field;
            ++simpleFieldNo;
        }
        for (int f = 0; f < oneToOneProperties.length; ++f) {
            NakedObjectAssociation field = oneToOneProperties[f];
            FieldMapping mapping = lookup.createMapping(field);
            this.fieldMappings.add(mapping);
        }
    }

    protected String columnList() {
        StringBuffer sql = new StringBuffer();
        for (FieldMapping mapping : this.fieldMappings) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            mapping.appendColumnNames(sql);
        }
        return sql.toString();
    }

    protected NakedObject getAdapter(NakedObjectSpecification specification, Oid oid) {
        AdapterManager objectLoader = NakedObjectsContext.getPersistenceSession().getAdapterManager();
        NakedObject adapter = objectLoader.getAdapterFor(oid);
        if (adapter != null) {
            return adapter;
        }
        return NakedObjectsContext.getPersistenceSession().recreateAdapter(oid, specification);
    }

    public boolean needsTables(DatabaseConnector connection) {
        for (int i = 0; this.collectionMappers != null && i < this.collectionMappers.length; ++i) {
            if (!this.collectionMappers[i].needsTables(connection)) continue;
            return true;
        }
        return !connection.hasTable(this.table);
    }

    public String toString() {
        return "AbstractAutoMapper [table=" + this.table + ",noColumns=" + this.fieldMappings.size() + ",nakedClass=" + this.specification.getFullName() + "]";
    }

    protected String values(NakedObject object) {
        StringBuffer sql = new StringBuffer();
        for (FieldMapping mapping : this.fieldMappings) {
            mapping.appendInsertValues(sql, object);
            sql.append(",");
        }
        return sql.toString();
    }

    protected String updateWhereClause(NakedObject object, boolean and) {
        Version version = object.getVersion();
        long versionNumber = ((SerialNumberVersion)version).getSequence();
        return and ? " and " + versionNumber + " = VERSION" : "";
    }
}

