/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.auto;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.sql.objectstore.AbstractMapper;
import org.nakedobjects.plugins.sql.objectstore.CollectionMapper;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.FieldMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.IdMapping;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.jdbc.JdbcObjectReferenceMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.ObjectReferenceMapping;
import org.nakedobjects.runtime.persistence.PersistorUtil;

public class AutoCollectionMapper
extends AbstractMapper
implements CollectionMapper {
    private static final Logger LOG = Logger.getLogger(AutoCollectionMapper.class);
    private String tableName;
    private NakedObjectAssociation field;
    private ObjectReferenceMapping elementMapping;
    private IdMapping idMapping;

    public AutoCollectionMapper(NakedObjectSpecification specification, NakedObjectAssociation field, FieldMappingLookup lookup) {
        this.field = field;
        NakedObjectSpecification spec = ((TypeOfFacet)field.getFacet(TypeOfFacet.class)).valueSpec();
        this.idMapping = lookup.createIdMapping();
        this.elementMapping = lookup.createMapping(spec);
        String className = specification.getShortName();
        String columnName = field.getId();
        this.tableName = this.asSqlName(className) + "_" + this.asSqlName(columnName);
    }

    public void createTables(DatabaseConnector connector) {
        if (!connector.hasTable(this.tableName)) {
            StringBuffer sql = new StringBuffer();
            sql.append("create table ");
            sql.append(this.tableName);
            sql.append(" (");
            this.idMapping.appendColumnDefinitions(sql);
            sql.append(", ");
            this.elementMapping.appendColumnDefinitions(sql);
            sql.append(")");
            connector.update(sql.toString());
        }
    }

    public void loadInternalCollection(DatabaseConnector connector, NakedObject parent) {
        NakedObject collection = this.field.get(parent);
        if (collection.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            LOG.debug((Object)("loading internal collection " + this.field));
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            this.idMapping.appendColumnNames(sql);
            sql.append(", ");
            this.elementMapping.appendColumnNames(sql);
            sql.append(" from ");
            sql.append(this.tableName);
            Results rs = connector.select(sql.toString());
            ArrayList<NakedObject> list = new ArrayList<NakedObject>();
            while (rs.next()) {
                NakedObject element = ((JdbcObjectReferenceMapping)this.elementMapping).initializeField(rs);
                LOG.debug((Object)("  element  " + element.getOid()));
                list.add(element);
            }
            CollectionFacet collectionFacet = (CollectionFacet)collection.getSpecification().getFacet(CollectionFacet.class);
            collectionFacet.init(collection, list.toArray(new NakedObject[list.size()]));
            rs.close();
            PersistorUtil.end((NakedObject)collection);
        }
    }

    public boolean needsTables(DatabaseConnector connector) {
        return !connector.hasTable(this.tableName);
    }

    public void saveInternalCollection(DatabaseConnector connector, NakedObject parent) {
        NakedObject collection = this.field.get(parent);
        LOG.debug((Object)("saving internal collection " + collection));
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ");
        sql.append(this.tableName);
        sql.append(" where ");
        this.idMapping.appendWhereClause(sql, parent);
        connector.update(sql.toString());
        sql = new StringBuffer();
        sql.append("insert into ");
        sql.append(this.tableName);
        sql.append(" (");
        this.idMapping.appendColumnNames(sql);
        sql.append(", ");
        this.elementMapping.appendColumnNames(sql);
        sql.append(" ) values (");
        this.idMapping.appendInsertValues(sql, parent);
        sql.append(", ");
        CollectionFacet collectionFacet = (CollectionFacet)collection.getSpecification().getFacet(CollectionFacet.class);
        for (NakedObject element : collectionFacet.iterable(collection)) {
            StringBuffer values = new StringBuffer();
            this.elementMapping.appendInsertValues(values, element);
            connector.update(sql.toString() + values + ")");
        }
    }
}

