/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.auto;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.SerialNumberVersion;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.FieldMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.IdMapping;
import org.nakedobjects.plugins.sql.objectstore.ObjectMapping;
import org.nakedobjects.plugins.sql.objectstore.ObjectMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStoreException;
import org.nakedobjects.plugins.sql.objectstore.VersionMapping;
import org.nakedobjects.plugins.sql.objectstore.auto.AbstractAutoMapper;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMapping;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.persistence.PersistorUtil;

public class AutoMapper
extends AbstractAutoMapper
implements ObjectMapping {
    private static final Logger LOG = Logger.getLogger(AutoMapper.class);
    private static final int MAX_INSTANCES = 100;
    private String instancesWhereClause;
    private final IdMapping idMapping;
    private final VersionMapping versionMapping;

    public AutoMapper(String nakedClassName, String parameterBase, FieldMappingLookup lookup) {
        super(nakedClassName, parameterBase, lookup);
        this.idMapping = lookup.createIdMapping();
        this.versionMapping = lookup.createVersionMapping();
    }

    public void createObject(DatabaseConnector connector, NakedObject object) {
        int versionSequence = 1;
        SerialNumberVersion version = this.createVersion(versionSequence);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + this.table + " (");
        this.idMapping.appendColumnNames(sql);
        sql.append(", ");
        sql.append(this.columnList());
        sql.append(", ");
        sql.append(this.versionMapping.insertColumns());
        sql.append(") values (");
        this.idMapping.appendInsertValues(sql, object);
        sql.append(", ");
        sql.append(this.values(object));
        sql.append(this.versionMapping.insertValues(version));
        sql.append(") ");
        connector.insert(sql.toString());
        object.setOptimisticLock((Version)version);
        for (int i = 0; i < this.collectionMappers.length; ++i) {
            this.collectionMappers[i].saveInternalCollection(connector, object);
        }
    }

    public void createTables(DatabaseConnector connection) {
        if (!connection.hasTable(this.table)) {
            StringBuffer sql = new StringBuffer();
            sql.append("create table ");
            sql.append(this.table);
            sql.append(" (");
            this.idMapping.appendColumnDefinitions(sql);
            sql.append(", ");
            for (FieldMapping mapping : this.fieldMappings) {
                mapping.appendColumnDefinitions(sql);
                sql.append(",");
            }
            sql.append(this.versionMapping.appendColumnDefinitions());
            sql.append(")");
            connection.update(sql.toString());
        }
        for (int i = 0; this.collectionMappers != null && i < this.collectionMappers.length; ++i) {
            if (!this.collectionMappers[i].needsTables(connection)) continue;
            this.collectionMappers[i].createTables(connection);
        }
    }

    public void destroyObject(DatabaseConnector connector, NakedObject object) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + this.table + " where ");
        this.idMapping.appendWhereClause(sql, object);
        sql.append(this.versionMapping.whereClause((SerialNumberVersion)object.getVersion()));
        int updateCount = connector.update(sql.toString());
        if (updateCount == 0) {
            LOG.info((Object)("concurrency conflict object " + this + "; no deletion performed"));
            throw new ConcurrencyException("", object.getOid());
        }
    }

    public NakedObject[] getInstances(DatabaseConnector connector, NakedObjectSpecification spec) {
        return this.loadInstances(connector, spec, this.createSelectStatement(null, null));
    }

    private String createSelectStatement(String whereClause, Oid oid) {
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        this.idMapping.appendColumnNames(sql);
        sql.append(", ");
        sql.append(this.columnList());
        sql.append(", ");
        sql.append(this.versionMapping.insertColumns());
        sql.append(" from " + this.table);
        if (whereClause != null) {
            sql.append(" where ");
            sql.append(whereClause);
        } else if (whereClause != null) {
            sql.append(" where ");
            this.idMapping.appendWhereClause(sql, oid);
        }
        sql.append(" order by ");
        this.idMapping.appendColumnNames(sql);
        return sql.toString();
    }

    public NakedObject[] getInstances(DatabaseConnector connector, NakedObjectSpecification spec, String pattern) {
        String where = this.instancesWhereClause + pattern;
        return this.loadInstances(connector, spec, this.createSelectStatement(where, null));
    }

    public NakedObject getObject(DatabaseConnector connector, Oid oid, NakedObjectSpecification hint) {
        Results rs = connector.select(this.createSelectStatement(null, oid));
        rs.next();
        return this.loadObject(connector, hint, rs);
    }

    public boolean hasInstances(DatabaseConnector connector, NakedObjectSpecification cls) {
        String statement = "select count(*) from " + this.table;
        int instances = connector.count(statement);
        return instances > 0;
    }

    protected void loadFields(NakedObject object, Results rs) {
        PersistorUtil.start((NakedObject)object, (ResolveState)ResolveState.RESOLVING);
        for (FieldMapping mapping : this.fieldMappings) {
            mapping.initializeField(object, rs);
        }
        object.setOptimisticLock(this.versionMapping.getLock(rs));
        PersistorUtil.end((NakedObject)object);
    }

    private NakedObject[] loadInstances(DatabaseConnector connector, NakedObjectSpecification cls, String selectStatment) {
        LOG.debug((Object)("loading instances from SQL " + this.table));
        Vector<NakedObject> instances = new Vector<NakedObject>();
        Results rs = connector.select(selectStatment);
        for (int count = 0; rs.next() && count < 100; ++count) {
            NakedObject instance = this.loadObject(connector, cls, rs);
            LOG.debug((Object)("  instance  " + instance));
            instances.addElement(instance);
        }
        rs.close();
        Object[] array = new NakedObject[instances.size()];
        instances.copyInto(array);
        return array;
    }

    private NakedObject loadObject(DatabaseConnector connector, NakedObjectSpecification cls, Results rs) {
        Oid oid = this.idMapping.recreateOid(rs, this.specification);
        NakedObject instance = this.getAdapter(cls, oid);
        if (instance.getResolveState().isValidToChangeTo(ResolveState.RESOLVING)) {
            this.loadFields(instance, rs);
        }
        return instance;
    }

    public void resolve(DatabaseConnector connector, NakedObject object) {
        LOG.debug((Object)("loading data from SQL " + this.table + " for " + object));
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(this.columnList());
        sql.append(",");
        sql.append(this.versionMapping.appendSelectColumns());
        sql.append(" from " + this.table + " where ");
        this.idMapping.appendWhereClause(sql, object);
        Results rs = connector.select(sql.toString());
        if (rs.next()) {
            this.loadFields(object, rs);
            rs.close();
            for (int i = 0; i < this.collectionMappers.length; ++i) {
                this.collectionMappers[i].loadInternalCollection(connector, object);
            }
        } else {
            rs.close();
            throw new SqlObjectStoreException("Unable to load data from " + this.table + " with id " + this.idMapping.primaryKey(object.getOid()));
        }
    }

    public void resolveCollection(DatabaseConnector connector, NakedObject object, NakedObjectAssociation field) {
        if (this.collectionMappers.length > 0) {
            DatabaseConnector secondConnector = connector.getConnectionPool().acquire();
            for (int i = 0; i < this.collectionMappers.length; ++i) {
                this.collectionMappers[i].loadInternalCollection(secondConnector, object);
            }
            connector.getConnectionPool().release(secondConnector);
        }
    }

    public void startup(DatabaseConnector connector, ObjectMappingLookup objectMapperLookup) {
        if (this.needsTables(connector)) {
            this.createTables(connector);
        }
    }

    public void save(DatabaseConnector connector, NakedObject object) {
        SerialNumberVersion version = (SerialNumberVersion)object.getVersion();
        long nextSequence = version.getSequence();
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.table + " set ");
        for (FieldMapping mapping : this.fieldMappings) {
            mapping.appendUpdateValues(sql, object);
            sql.append(", ");
        }
        sql.append(this.versionMapping.updateAssigment(nextSequence));
        sql.append(" where ");
        this.idMapping.appendWhereClause(sql, object);
        sql.append(" and ");
        sql.append(this.versionMapping.whereClause((SerialNumberVersion)object.getVersion()));
        int updateCount = connector.update(sql.toString());
        if (updateCount == 0) {
            LOG.info((Object)("concurrency conflict object " + this + "; no update performed"));
            throw new ConcurrencyException("", object.getOid());
        }
        object.setOptimisticLock((Version)this.createVersion(nextSequence));
        for (int i = 0; i < this.collectionMappers.length; ++i) {
            this.collectionMappers[i].saveInternalCollection(connector, object);
        }
    }

    public String toString() {
        return "AutoMapper [table=" + this.table + ",id=" + this.idMapping + ",noColumns=" + this.fieldMappings.size() + ",nakedClass=" + this.specification.getFullName() + "]";
    }
}

