/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.auto;

import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.SerialNumberVersion;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.sql.objectstore.CollectionMapper;
import org.nakedobjects.plugins.sql.objectstore.DatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.FieldMappingLookup;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.VersionMapping;
import org.nakedobjects.plugins.sql.objectstore.auto.AbstractAutoMapper;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.ObjectReferenceMapping;
import org.nakedobjects.runtime.persistence.PersistorUtil;

public class ReversedAutoAssociationMapper
extends AbstractAutoMapper
implements CollectionMapper {
    private static final Logger LOG = Logger.getLogger(ReversedAutoAssociationMapper.class);
    private NakedObjectAssociation field;
    private final ObjectReferenceMapping idMapping;
    private final VersionMapping versionMapping;

    public ReversedAutoAssociationMapper(String elemenType, NakedObjectAssociation field, String parameterBase, FieldMappingLookup lookup) {
        super(elemenType, parameterBase, lookup);
        this.field = field;
        this.idMapping = lookup.createMapping(field.getSpecification());
        this.versionMapping = lookup.createVersionMapping();
    }

    public void createTables(DatabaseConnector connection) {
        if (!connection.hasTable(this.table)) {
            StringBuffer sql = new StringBuffer();
            sql.append("create table ");
            sql.append(this.table);
            sql.append(" (");
            this.idMapping.appendColumnDefinitions(sql);
            sql.append(", ");
            for (FieldMapping mapping : this.fieldMappings) {
                mapping.appendColumnDefinitions(sql);
                sql.append(",");
            }
            sql.append(this.versionMapping.appendColumnDefinitions());
            sql.append(")");
            connection.update(sql.toString());
        }
        for (int i = 0; this.collectionMappers != null && i < this.collectionMappers.length; ++i) {
            if (!this.collectionMappers[i].needsTables(connection)) continue;
            this.collectionMappers[i].createTables(connection);
        }
    }

    public void loadInternalCollection(DatabaseConnector connector, NakedObject parent) {
        NakedObject collection = this.field.get(parent);
        if (collection.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            LOG.debug((Object)("loading internal collection " + this.field));
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            this.idMapping.appendColumnNames(sql);
            sql.append(", ");
            sql.append(this.columnList());
            sql.append(" from ");
            sql.append(this.table);
            sql.append(" where ");
            this.idMapping.appendUpdateValues(sql, parent);
            Results rs = connector.select(sql.toString());
            ArrayList<NakedObject> list = new ArrayList<NakedObject>();
            while (rs.next()) {
                Oid oid = this.idMapping.recreateOid(rs, this.specification);
                NakedObject element = this.getAdapter(this.specification, oid);
                this.loadFields(element, rs);
                LOG.debug((Object)("  element  " + element.getOid()));
                list.add(element);
            }
            CollectionFacet collectionFacet = (CollectionFacet)collection.getSpecification().getFacet(CollectionFacet.class);
            collectionFacet.init(collection, list.toArray(new NakedObject[list.size()]));
            rs.close();
            PersistorUtil.end((NakedObject)collection);
        }
    }

    protected void loadFields(NakedObject object, Results rs) {
        PersistorUtil.start((NakedObject)object, (ResolveState)ResolveState.RESOLVING);
        for (FieldMapping mapping : this.fieldMappings) {
            mapping.initializeField(object, rs);
        }
        object.setOptimisticLock(this.versionMapping.getLock(rs));
        PersistorUtil.end((NakedObject)object);
    }

    public void saveInternalCollection(DatabaseConnector connector, NakedObject parent) {
        NakedObject collection = this.field.get(parent);
        LOG.debug((Object)("Saving internal collection " + collection));
        this.deleteAllElments(connector, parent);
        this.reinsertElements(connector, parent, collection);
    }

    private void reinsertElements(DatabaseConnector connector, NakedObject parent, NakedObject collection) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + this.table + " (");
        this.idMapping.appendColumnNames(sql);
        sql.append(", ");
        sql.append(this.columnList());
        sql.append(", ");
        sql.append(this.versionMapping.insertColumns());
        sql.append(") values (");
        this.idMapping.appendInsertValues(sql, parent);
        sql.append(", ");
        CollectionFacet collectionFacet = (CollectionFacet)this.field.getFacet(CollectionFacet.class);
        for (NakedObject element : collectionFacet.iterable(collection)) {
            StringBuffer insert = new StringBuffer(sql);
            insert.append(this.values(element));
            SerialNumberVersion version = new SerialNumberVersion(0L, "", new Date());
            insert.append(this.versionMapping.insertValues(version));
            insert.append(") ");
            connector.insert(insert.toString());
            element.setOptimisticLock((Version)version);
        }
    }

    private void deleteAllElments(DatabaseConnector connector, NakedObject parent) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ");
        sql.append(this.table);
        sql.append(" where ");
        this.idMapping.appendUpdateValues(sql, parent);
        connector.update(sql.toString());
    }
}

