/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.jdbc;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.sql.objectstore.FieldNameMapper;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMapping;

public abstract class AbstractJdbcFieldMapping
implements FieldMapping {
    private String columnName;
    private final NakedObjectAssociation field;

    public AbstractJdbcFieldMapping(NakedObjectAssociation field) {
        this.field = field;
        this.columnName = FieldNameMapper.getInstance().getColumnName(field.getName());
    }

    public void appendColumnDefinitions(StringBuffer sql) {
        sql.append(this.columnName);
        sql.append(" ");
        sql.append(this.columnType());
    }

    public void appendColumnNames(StringBuffer sql) {
        sql.append(this.columnName);
    }

    public void appendInsertValues(StringBuffer sql, NakedObject object) {
        NakedObject fieldValue = this.field.get(object);
        if (fieldValue == null) {
            sql.append("NULL");
        } else {
            sql.append(this.valueAsDBString(fieldValue));
        }
    }

    public void appendUpdateValues(StringBuffer sql, NakedObject object) {
        sql.append(FieldNameMapper.getInstance().getColumnName(this.field.getName()));
        sql.append('=');
        NakedObject fieldValue = this.field.get(object);
        sql.append(this.valueAsDBString(fieldValue));
    }

    public void initializeField(NakedObject object, Results rs) {
        String columnName = FieldNameMapper.getInstance().getColumnName(this.field.getName());
        String encodedValue = rs.getString(columnName);
        NakedObject restoredValue = encodedValue == null ? null : this.setFromDBColumn(encodedValue, this.field);
        ((OneToOneAssociation)this.field).initAssociation(object, restoredValue);
    }

    protected abstract String columnType();

    protected abstract String valueAsDBString(NakedObject var1);

    protected abstract NakedObject setFromDBColumn(String var1, NakedObjectAssociation var2);
}

