/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.sql.objectstore.AbstractDatabaseConnector;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStoreException;
import org.nakedobjects.plugins.sql.objectstore.jdbc.JdbcResults;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class JdbcConnector
extends AbstractDatabaseConnector {
    private static final Logger LOG = Logger.getLogger(JdbcConnector.class);
    private Connection connection;

    public void close() {
        try {
            if (this.connection != null) {
                LOG.info((Object)"close");
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException("Failed to close", e);
        }
    }

    public int count(String sql) {
        LOG.debug((Object)("SQL: " + sql));
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            ResultSet result = statement.executeQuery();
            result.next();
            int count = result.getInt(1);
            statement.close();
            return count;
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException("Failed count", e);
        }
    }

    public void delete(String sql) {
        this.update(sql);
    }

    public void open() {
        try {
            NakedObjectConfiguration params = NakedObjectsContext.getConfiguration();
            String BASE = "nakedobjects.persistence.sql.jdbc.";
            String driver = params.getString(BASE + "driver");
            String url = params.getString(BASE + "connection");
            String user = params.getString(BASE + "user");
            String password = params.getString(BASE + "password");
            if (driver == null) {
                throw new SqlObjectStoreException("No driver specified for database connection");
            }
            if (url == null) {
                throw new SqlObjectStoreException("No connection URL specified to database");
            }
            if (user == null) {
                throw new SqlObjectStoreException("No user specified for database connection");
            }
            if (password == null) {
                throw new SqlObjectStoreException("No password specified for database connection");
            }
            Class.forName(driver);
            LOG.info((Object)("Connecting to " + url + " as " + user));
            this.connection = DriverManager.getConnection(url, user, password);
            if (this.connection == null) {
                throw new SqlObjectStoreException("No connection established to " + url);
            }
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException("Failed to start", e);
        }
        catch (ClassNotFoundException e) {
            throw new SqlObjectStoreException("Could not find database driver", e);
        }
    }

    public Results select(String sql) {
        LOG.debug((Object)("SQL: " + sql));
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            return new JdbcResults(statement.executeQuery());
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException(e);
        }
    }

    public int update(String sql) {
        LOG.debug((Object)("SQL: " + sql));
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            int updateCount = statement.executeUpdate();
            statement.close();
            return updateCount;
        }
        catch (SQLException e) {
            LOG.error((Object)("failed to execute " + sql));
            throw new SqlObjectStoreException("SQL error", e);
        }
    }

    public boolean hasTable(String tableName) {
        try {
            ResultSet set = this.connection.getMetaData().getTables(null, null, tableName, null);
            if (set.next()) {
                LOG.debug((Object)("Found " + set.getString("TABLE_NAME")));
                set.close();
                return true;
            }
            set.close();
            return false;
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException(e);
        }
    }

    public void insert(String sql) {
        this.update(sql);
    }

    public void insert(String sql, Object oid) {
        LOG.debug((Object)("SQL: " + sql));
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException("SQL error", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void commit() {
        try {
            LOG.debug((Object)"commit");
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException("Commit error", e);
        }
    }

    public void begin() {
        try {
            LOG.debug((Object)"begin transaction");
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException("Rollback error", e);
        }
    }

    public void rollback() {
        try {
            LOG.debug((Object)"rollback");
            this.connection.rollback();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new SqlObjectStoreException("Rollback error", e);
        }
    }
}

