/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.jdbc;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.sql.objectstore.jdbc.AbstractJdbcFieldMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMappingFactory;

public class JdbcDateMapper
extends AbstractJdbcFieldMapping {
    protected JdbcDateMapper(NakedObjectAssociation field) {
        super(field);
    }

    public String valueAsDBString(NakedObject value) {
        EncodableFacet encodeableFacet = (EncodableFacet)value.getSpecification().getFacet(EncodableFacet.class);
        String encodedString = encodeableFacet.toEncodedString(value);
        String year = encodedString.substring(0, 4);
        String month = encodedString.substring(4, 6);
        String day = encodedString.substring(6, 8);
        String encodedWithAdaptions = year + "-" + month + "-" + day;
        return "'" + encodedWithAdaptions + "'";
    }

    public NakedObject setFromDBColumn(String encodedValue, NakedObjectAssociation field) {
        String year = encodedValue.substring(0, 4);
        String month = encodedValue.substring(5, 7);
        String day = encodedValue.substring(8, 10);
        String valueString = year + month + day;
        return ((EncodableFacet)field.getSpecification().getFacet(EncodableFacet.class)).fromEncodedString(valueString);
    }

    public String columnType() {
        return "DATE";
    }

    public static class Factory
    implements FieldMappingFactory {
        public FieldMapping createFieldMapping(NakedObjectAssociation field) {
            return new JdbcDateMapper(field);
        }
    }
}

