/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.jdbc;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.sql.objectstore.FieldNameMapper;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.jdbc.JdbcObjectReferenceMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMappingFactory;

public class JdbcObjectReferenceFieldMapping
extends JdbcObjectReferenceMapping
implements FieldMapping {
    final NakedObjectAssociation field;

    public JdbcObjectReferenceFieldMapping(NakedObjectAssociation field) {
        super(JdbcObjectReferenceFieldMapping.columnName(field), field.getSpecification());
        this.field = field;
    }

    private static String columnName(NakedObjectAssociation field) {
        return FieldNameMapper.getInstance().getColumnName(field.getName());
    }

    public void appendInsertValues(StringBuffer sb, NakedObject object) {
        NakedObject fieldValue = this.field.get(object);
        super.appendInsertValues(sb, fieldValue);
    }

    public void appendUpdateValues(StringBuffer sql, NakedObject object) {
        NakedObject fieldValue = this.field.get(object);
        super.appendUpdateValues(sql, fieldValue);
    }

    public void initializeField(NakedObject object, Results rs) {
        NakedObject reference = this.initializeField(rs);
        ((OneToOneAssociation)this.field).initAssociation(object, reference);
    }

    public static class Factory
    implements FieldMappingFactory {
        public FieldMapping createFieldMapping(NakedObjectAssociation field) {
            return new JdbcObjectReferenceFieldMapping(field);
        }
    }
}

