/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.jdbc;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.sql.objectstore.FieldNameMapper;
import org.nakedobjects.plugins.sql.objectstore.IdMappingAbstract;
import org.nakedobjects.plugins.sql.objectstore.Results;
import org.nakedobjects.plugins.sql.objectstore.SqlObjectStoreException;
import org.nakedobjects.plugins.sql.objectstore.mapping.ObjectReferenceMapping;

public class JdbcObjectReferenceMapping
extends IdMappingAbstract
implements ObjectReferenceMapping {
    private NakedObjectSpecification specification;

    public JdbcObjectReferenceMapping(String columnName, NakedObjectSpecification specification) {
        this.specification = specification;
        String idColumn = FieldNameMapper.getInstance().getColumnName("FK_" + columnName);
        this.setColumn(idColumn);
    }

    public void appendUpdateValues(StringBuffer sql, NakedObject object) {
        sql.append(this.getColumn());
        if (object == null) {
            sql.append("= NULL ");
        } else {
            sql.append("='");
            sql.append(this.primaryKey(object.getOid()));
            sql.append("'");
        }
    }

    public NakedObject initializeField(Results rs) {
        Oid oid = this.recreateOid(rs, this.specification);
        if (oid != null) {
            if (this.specification.isAbstract()) {
                throw new SqlObjectStoreException("NOT DEALING WITH POLYMORPHIC ASSOCIATIONS");
            }
            return this.getAdapter(this.specification, oid);
        }
        return null;
    }
}

