/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.sql.objectstore.jdbc;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.sql.objectstore.jdbc.AbstractJdbcFieldMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMapping;
import org.nakedobjects.plugins.sql.objectstore.mapping.FieldMappingFactory;

public class JdbcTimeMapper
extends AbstractJdbcFieldMapping {
    protected JdbcTimeMapper(NakedObjectAssociation field) {
        super(field);
    }

    public String valueAsDBString(NakedObject value) {
        EncodableFacet encodeableFacet = (EncodableFacet)value.getSpecification().getFacet(EncodableFacet.class);
        String encodedString = encodeableFacet.toEncodedString(value);
        String minute = encodedString.substring(2, 4);
        String hour = encodedString.substring(0, 2);
        String encodedWithAdaptions = hour + ":" + minute + ":00";
        return "'" + encodedWithAdaptions + "'";
    }

    public NakedObject setFromDBColumn(String encodedValue, NakedObjectAssociation field) {
        String hour = encodedValue.substring(0, 2);
        String minute = encodedValue.substring(3, 5);
        String valueString = hour + minute;
        return ((EncodableFacet)field.getSpecification().getFacet(EncodableFacet.class)).fromEncodedString(valueString);
    }

    public String columnType() {
        return "TIME";
    }

    public static class Factory
    implements FieldMappingFactory {
        public FieldMapping createFieldMapping(NakedObjectAssociation field) {
            return new JdbcTimeMapper(field);
        }
    }
}

