/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore;

import java.util.Collections;
import junit.textui.TestRunner;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.version.SerialNumberVersion;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.xml.objectstore.XmlObjectStore;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.Clock;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.TestClock;
import org.nakedobjects.plugins.xml.objectstore.internal.data.DataManager;
import org.nakedobjects.plugins.xml.objectstore.internal.data.MockDataManager;
import org.nakedobjects.plugins.xml.objectstore.internal.services.DummyServiceManager;
import org.nakedobjects.plugins.xml.objectstore.internal.services.ServiceManager;
import org.nakedobjects.plugins.xml.objectstore.internal.version.FileVersion;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestSpecification;

public class XmlObjectStoreTest
extends ProxyJunit3TestCase {
    private XmlObjectStore objectStore;
    private MockDataManager dataManager;
    private TestProxyNakedObject nakedObject;
    private TestSpecification spec;

    public static void main(String[] args) {
        TestRunner.run(XmlObjectStoreTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dataManager = new MockDataManager();
        this.objectStore = new XmlObjectStore((DataManager)this.dataManager, (ServiceManager)new DummyServiceManager());
        this.objectStore.setClock((Clock)new TestClock());
        this.spec = new TestSpecification();
        this.spec.fields = new NakedObjectAssociation[0];
        this.nakedObject = new TestProxyNakedObject();
        this.nakedObject.setupSpecification((NakedObjectSpecification)this.spec);
        this.nakedObject.setOptimisticLock((Version)new SerialNumberVersion(23L, null, null));
    }

    public void testSaveObjectCreatesNewVersion() throws Exception {
        this.nakedObject.setOptimisticLock(null);
        CreateObjectCommand command = this.objectStore.createCreateObjectCommand((NakedObject)this.nakedObject);
        this.objectStore.execute(Collections.singletonList(command));
        XmlObjectStoreTest.assertEquals((Object)new FileVersion(null, 1L), (Object)this.nakedObject.getVersion());
    }

    public void testDeleteObjectRemovesVersion() throws Exception {
        DestroyObjectCommand command = this.objectStore.createDestroyObjectCommand((NakedObject)this.nakedObject);
        this.objectStore.execute(Collections.singletonList(command));
        XmlObjectStoreTest.assertEquals(null, (Object)this.nakedObject.getVersion());
    }

    public void testUpdateObjectCreatesNewVersion() throws Exception {
        SaveObjectCommand command = this.objectStore.createSaveObjectCommand((NakedObject)this.nakedObject);
        this.objectStore.execute(Collections.singletonList(command));
        XmlObjectStoreTest.assertEquals((Object)new FileVersion(null, 1L), (Object)this.nakedObject.getVersion());
    }
}

