/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.data.xml;

import java.io.File;
import java.io.FilenameFilter;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.Clock;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.TestClock;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ObjectData;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ReferenceVector;
import org.nakedobjects.plugins.xml.objectstore.internal.data.Role;
import org.nakedobjects.plugins.xml.objectstore.internal.data.Team;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlDataManager;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlFile;
import org.nakedobjects.plugins.xml.objectstore.internal.version.FileVersion;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDataManagerTest
extends ProxyJunit3TestCase {
    protected XmlDataManager manager;

    protected void setUp() throws Exception {
        super.setUp();
        FileVersion.setClock((Clock)new TestClock());
        XmlDataManagerTest.clearTestDirectory();
        this.manager = new XmlDataManager(new XmlFile((NakedObjectConfiguration)this.system.getConfiguration(), "tmp/tests"));
    }

    protected void tearDown() throws Exception {
        this.system.shutdown();
    }

    protected static void clearTestDirectory() {
        File directory = new File("tmp" + File.separator + "tests");
        String[] files = directory.list(new FilenameFilter(){

            public boolean accept(File arg0, String name) {
                return name.endsWith(".xml");
            }
        });
        if (files != null) {
            for (int f = 0; f < files.length; ++f) {
                new File(directory, files[f]).delete();
            }
        }
    }

    public void testWriteReadTypeOidAndVersion() {
        ObjectData data = this.createData(Role.class, 99L, new FileVersion("user", 19L));
        this.manager.insertObject(data);
        ObjectData read = (ObjectData)this.manager.loadData(data.getOid());
        XmlDataManagerTest.assertEquals((Object)data.getOid(), (Object)read.getOid());
        XmlDataManagerTest.assertEquals((String)data.getTypeName(), (String)read.getTypeName());
        XmlDataManagerTest.assertEquals((Object)data.getVersion(), (Object)read.getVersion());
    }

    public void testNextId() throws Exception {
        long first = this.manager.nextId();
        XmlDataManagerTest.assertEquals((long)(first + 1L), (long)this.manager.nextId());
        XmlDataManagerTest.assertEquals((long)(first + 2L), (long)this.manager.nextId());
        XmlDataManagerTest.assertEquals((long)(first + 3L), (long)this.manager.nextId());
    }

    public void testInsertObjectWithFields() throws ObjectPersistenceException {
        ObjectData data = this.createData(Role.class, 99L, new FileVersion("user", 13L));
        data.set("Person", (Object)SerialOid.createPersistent((long)101L));
        XmlDataManagerTest.assertNotNull((Object)data.get("Person"));
        data.set("Name", "Harry");
        XmlDataManagerTest.assertNotNull((Object)data.get("Name"));
        this.manager.insertObject(data);
        ObjectData read = (ObjectData)this.manager.loadData(data.getOid());
        XmlDataManagerTest.assertEquals((Object)data.getOid(), (Object)read.getOid());
        XmlDataManagerTest.assertEquals((String)data.getTypeName(), (String)read.getTypeName());
        XmlDataManagerTest.assertEquals((Object)data.get("Person"), (Object)read.get("Person"));
        XmlDataManagerTest.assertEquals((Object)data.get("Name"), (Object)read.get("Name"));
    }

    public void testInsertObjectWithEmptyOneToManyAssociations() throws ObjectPersistenceException {
        ObjectData data = this.createData(Team.class, 99L, new FileVersion("user", 13L));
        data.initCollection("Members");
        this.manager.insertObject(data);
        ObjectData read = (ObjectData)this.manager.loadData(data.getOid());
        XmlDataManagerTest.assertEquals((Object)data.getOid(), (Object)read.getOid());
        XmlDataManagerTest.assertEquals((String)data.getTypeName(), (String)read.getTypeName());
        ReferenceVector c = read.elements("Members");
        XmlDataManagerTest.assertNull((Object)c);
    }

    public void testInsertObjectWithOneToManyAssociations() throws ObjectPersistenceException {
        ObjectData data = this.createData(Team.class, 99L, new FileVersion("user", 13L));
        data.initCollection("Members");
        SerialOid[] oid = new SerialOid[3];
        for (int i = 0; i < oid.length; ++i) {
            oid[i] = SerialOid.createPersistent((long)(104 + i));
            data.addElement("Members", oid[i]);
        }
        this.manager.insertObject(data);
        ObjectData read = (ObjectData)this.manager.loadData(data.getOid());
        XmlDataManagerTest.assertEquals((Object)data.getOid(), (Object)read.getOid());
        XmlDataManagerTest.assertEquals((String)data.getTypeName(), (String)read.getTypeName());
        ReferenceVector c = read.elements("Members");
        for (int i = 0; i < oid.length; ++i) {
            XmlDataManagerTest.assertEquals((Object)oid[i], (Object)c.elementAt(i));
        }
    }

    private ObjectData createData(Class<?> type, long id, FileVersion version) {
        NakedObjectSpecification noSpec = NakedObjectsContext.getSpecificationLoader().loadSpecification(type);
        SerialOid oid = SerialOid.createPersistent((long)id);
        return new ObjectData(noSpec, oid, version);
    }
}

