/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.commands;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.xml.objectstore.internal.data.DataManager;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ObjectData;
import org.nakedobjects.plugins.xml.objectstore.internal.version.FileVersion;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;
import org.nakedobjects.runtime.transaction.PersistenceCommandAbstract;

abstract class AbstractXmlPersistenceCommand
extends PersistenceCommandAbstract {
    private static final Logger LOG = Logger.getLogger(AbstractXmlPersistenceCommand.class);
    private final DataManager dataManager;

    public AbstractXmlPersistenceCommand(NakedObject adapter, DataManager dataManager) {
        super(adapter);
        this.dataManager = dataManager;
    }

    protected DataManager getDataManager() {
        return this.dataManager;
    }

    protected ObjectData createObjectData(NakedObject adapter, boolean ensurePersistent) {
        NakedObjectAssociation[] associations;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("compiling object data for " + adapter));
        }
        NakedObjectSpecification adapterSpec = adapter.getSpecification();
        ObjectData data = new ObjectData(adapterSpec, (SerialOid)adapter.getOid(), (FileVersion)adapter.getVersion());
        for (NakedObjectAssociation association : associations = adapterSpec.getAssociations()) {
            if (!association.isNotDerived()) continue;
            NakedObject associatedObject = association.get(adapter);
            boolean isEmpty = association.isEmpty(adapter);
            String associationId = association.getId();
            if (association.isOneToManyAssociation()) {
                this.saveCollection(associationId, data, associatedObject, ensurePersistent);
                continue;
            }
            if (association.getSpecification().isEncodeable()) {
                this.saveEncoded(data, associationId, associatedObject, isEmpty);
                continue;
            }
            if (!association.isOneToOneAssociation()) continue;
            this.saveReference(data, associationId, associatedObject, ensurePersistent);
        }
        return data;
    }

    private void saveReference(ObjectData data, String associationId, NakedObject associatedObject, boolean ensurePersistent) {
        data.addAssociation(associatedObject, associationId, ensurePersistent);
    }

    private void saveCollection(String associationId, ObjectData data, NakedObject associatedObject, boolean ensurePersistent) {
        data.addInternalCollection(associatedObject, associationId, ensurePersistent);
    }

    private void saveEncoded(ObjectData data, String associationId, NakedObject associatedObject, boolean isEmpty) {
        if (associatedObject == null || isEmpty) {
            data.saveValue(associationId, isEmpty, null);
        } else {
            EncodeableFacet facet = (EncodeableFacet)associatedObject.getSpecification().getFacet(EncodeableFacet.class);
            String encodedValue = facet.toEncodedString(associatedObject);
            data.saveValue(associationId, isEmpty, encodedValue);
        }
    }
}

