/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.services.xml;

import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlFile;
import org.nakedobjects.plugins.xml.objectstore.internal.services.ServiceManager;
import org.nakedobjects.plugins.xml.objectstore.internal.services.xml.ServiceElement;
import org.nakedobjects.plugins.xml.objectstore.internal.services.xml.ServiceHandler;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;

public class XmlServiceManager
implements ServiceManager {
    private static final String SERVICES_FILE_NAME = "services";
    private Vector services;
    private final XmlFile xmlFile;

    public XmlServiceManager(XmlFile xmlFile) {
        this.xmlFile = xmlFile;
    }

    private String encodedOid(SerialOid oid) {
        return Long.toHexString(oid.getSerialNo()).toUpperCase();
    }

    public Oid getOidForService(String name) {
        Enumeration e = this.services.elements();
        while (e.hasMoreElements()) {
            ServiceElement element = (ServiceElement)e.nextElement();
            if (!element.id.equals(name)) continue;
            return element.oid;
        }
        return null;
    }

    public void loadServices() {
        ServiceHandler handler = new ServiceHandler();
        this.xmlFile.parse(handler, SERVICES_FILE_NAME);
        this.services = handler.services;
    }

    public void registerService(String name, Oid oid) {
        SerialOid soid = (SerialOid)oid;
        ServiceElement element = new ServiceElement(soid, name);
        this.services.addElement(element);
        this.saveServices();
    }

    public final void saveServices() {
        StringBuffer xml = new StringBuffer();
        String tag = SERVICES_FILE_NAME;
        xml.append("<services>\n");
        Enumeration e = this.services.elements();
        while (e.hasMoreElements()) {
            ServiceElement element = (ServiceElement)e.nextElement();
            xml.append("  <service oid=\"");
            xml.append(this.encodedOid(element.oid));
            xml.append("\" id=\"");
            xml.append(element.id);
            xml.append("\" />\n");
        }
        xml.append("</services>\n");
        this.xmlFile.writeXml(SERVICES_FILE_NAME, xml);
    }
}

