package org.nakedobjects.plugins.xml.objectstore.internal.version;

import java.io.Serializable;
import java.util.Date;

import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.adapter.version.VersionAbstract;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.Clock;


public class FileVersion extends VersionAbstract implements Encodable, Serializable {
    private static final long serialVersionUID = 1L;
    private static Clock clock;

    public static void setClock(final Clock clock) {
        FileVersion.clock = clock;
    }

    public FileVersion(final String user) {
        this(user, clock.getTime());
    }

    public FileVersion(final String user, final long sequence) {
        super(user, new Date(sequence));
    }

    public FileVersion(final ByteDecoder decoder) {
        super(decoder.getString(), new Date(decoder.getLong()));
    }

    public void encode(final ByteEncoder encoder) {
        encoder.add(user);
        encoder.add(time.getTime());
    }

    @Override
    protected VersionAbstract next() {
        // return new FileVersion(user);
        throw new NotYetImplementedException();
    }

    public boolean different(final Version version) {
        if (version instanceof FileVersion) {
            final FileVersion other = (FileVersion) version;
            return !sameTime(other);
        } else {
            return false;
        }
    }

    private boolean sameTime(final FileVersion other) {
        return time.getTime() == other.time.getTime();
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj == this) {
            return true;
        } else if (obj instanceof FileVersion) {
            return sameTime((FileVersion) obj);
        } else {
            return false;
        }
    }

    public long getSequence() {
        return time.getTime();
    }

    public String sequence() {
        return Long.toString(getSequence(), 16);
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("sequence", time.getTime());
        str.append("time", time);
        str.append("user", user);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
