/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.data.xml;

import java.io.File;
import java.io.FilenameFilter;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.Clock;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.TestClock;
import org.nakedobjects.plugins.xml.objectstore.internal.data.Data;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ObjectData;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ObjectDataVector;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlDataManager;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlFile;
import org.nakedobjects.plugins.xml.objectstore.internal.version.FileVersion;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;

public class XmlDataManagerInstancesTest
extends ProxyJunit3TestCase {
    private static final Logger LOG = Logger.getLogger(XmlDataManagerInstancesTest.class);
    protected XmlDataManager manager;
    protected final int SIZE = 5;
    private SerialOid[] oids;
    private ObjectData[] data;
    private ObjectData pattern;

    public static void main(String[] args) {
        TestRunner.run(XmlDataManagerInstancesTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlDataManagerInstancesTest.clearTestDirectory();
        this.manager = new XmlDataManager(new XmlFile((NakedObjectConfiguration)this.system.getConfiguration(), "tmp/tests"));
        FileVersion.setClock((Clock)new TestClock());
        this.oids = new SerialOid[5];
        this.data = new ObjectData[5];
        TestProxySpecification type = this.system.getSpecification(Object.class);
        this.pattern = new ObjectData((NakedObjectSpecification)type, null, new FileVersion("user", 13L));
        for (int i = 0; i < 5; ++i) {
            this.oids[i] = SerialOid.createPersistent((long)i);
            this.data[i] = new ObjectData((NakedObjectSpecification)type, this.oids[i], new FileVersion("user", 13L));
            this.manager.insertObject(this.data[i]);
        }
        LOG.debug((Object)"test starting...");
    }

    protected static void clearTestDirectory() {
        File directory = new File("tmp" + File.separator + "tests");
        String[] files = directory.list(new FilenameFilter(){

            public boolean accept(File arg0, String name) {
                return name.endsWith(".xml");
            }
        });
        if (files != null) {
            for (int f = 0; f < files.length; ++f) {
                new File(directory, files[f]).delete();
            }
        }
    }

    protected void tearDown() throws Exception {
        this.system.shutdown();
        super.tearDown();
    }

    public void testNumberOfInstances() {
        XmlDataManagerInstancesTest.assertEquals((int)5, (int)this.manager.numberOfInstances(this.pattern));
    }

    public void testRemove() throws Exception {
        SerialOid oid = this.oids[2];
        this.manager.remove(oid);
        XmlDataManagerInstancesTest.assertEquals((int)4, (int)this.manager.numberOfInstances(this.pattern));
        ObjectDataVector instances = this.manager.getInstances(this.pattern);
        for (int i = 0; i < instances.size(); ++i) {
            XmlDataManagerInstancesTest.assertFalse((instances.element(i) == this.data[2] ? 1 : 0) != 0);
        }
        XmlDataManagerInstancesTest.assertNull((Object)((ObjectData)this.manager.loadData(oid)));
    }

    public void testSaveObject() throws Exception {
        this.data[2].set("Person", (Object)SerialOid.createPersistent((long)231L));
        this.data[2].set("Name", "Fred");
        this.manager.save((Data)this.data[2]);
        XmlDataManagerInstancesTest.assertTrue((boolean)this.manager.getInstances(this.pattern).contains(this.data[2]));
        ObjectData read = (ObjectData)this.manager.loadData(this.oids[2]);
        XmlDataManagerInstancesTest.assertEquals((Object)this.data[2], (Object)read);
        XmlDataManagerInstancesTest.assertEquals((Object)this.data[2].get("Name"), (Object)read.get("Name"));
        XmlDataManagerInstancesTest.assertEquals((Object)this.data[2].get("Person"), (Object)read.get("Person"));
    }
}

