/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.data;

import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.xml.objectstore.internal.data.Data;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ReferenceVector;
import org.nakedobjects.plugins.xml.objectstore.internal.version.FileVersion;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectData
extends Data {
    private final Map<String, Object> fieldById = new HashMap<String, Object>();

    public ObjectData(NakedObjectSpecification noSpec, SerialOid oid, FileVersion version) {
        super(noSpec, oid, version);
    }

    public Iterable<String> fields() {
        return this.fieldById.keySet();
    }

    public String id(String fieldId) {
        Object field = this.get(fieldId);
        return field == null ? null : "" + ((SerialOid)field).getSerialNo();
    }

    public void set(String fieldId, String value) {
        this.fieldById.put(fieldId, value);
    }

    public void saveValue(String fieldId, boolean isEmpty, String encodedString) {
        if (isEmpty) {
            this.fieldById.remove(fieldId);
        } else {
            this.fieldById.put(fieldId, encodedString);
        }
    }

    public String value(String fieldId) {
        return (String)this.get(fieldId);
    }

    public Object get(String fieldId) {
        return this.fieldById.get(fieldId);
    }

    public void set(String fieldId, Object oid) {
        if (oid == null) {
            this.fieldById.remove(fieldId);
        } else {
            this.fieldById.put(fieldId, oid);
        }
    }

    public void initCollection(String fieldId) {
        this.fieldById.put(fieldId, new ReferenceVector());
    }

    public void addElement(String fieldId, SerialOid elementOid) {
        if (!this.fieldById.containsKey(fieldId)) {
            throw new NakedObjectException("Field " + fieldId + " not found  in hashtable");
        }
        ReferenceVector v = (ReferenceVector)this.fieldById.get(fieldId);
        v.add(elementOid);
    }

    public ReferenceVector elements(String fieldId) {
        return (ReferenceVector)this.fieldById.get(fieldId);
    }

    public void addAssociation(NakedObject fieldContent, String fieldId, boolean ensurePersistent) {
        boolean notAlreadyPersistent;
        boolean bl = notAlreadyPersistent = fieldContent != null && fieldContent.isTransient();
        if (ensurePersistent && notAlreadyPersistent) {
            throw new IllegalStateException("Cannot save an object that is not persistent: " + fieldContent);
        }
        this.set(fieldId, fieldContent == null ? null : fieldContent.getOid());
    }

    public void addInternalCollection(NakedObject collection, String fieldId, boolean ensurePersistent) {
        this.initCollection(fieldId);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        for (NakedObject element : facet.iterable(collection)) {
            Oid elementOid = element.getOid();
            if (elementOid == null) {
                throw new IllegalStateException("Element is not persistent " + element);
            }
            this.addElement(fieldId, (SerialOid)elementOid);
        }
    }

    public String toString() {
        return "ObjectData[type=" + this.getTypeName() + ",oid=" + this.getOid() + ",fields=" + this.fieldById + "]";
    }
}

