/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.data.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlFile {
    private static final String ENCODING_PROPERTY = "nakedobjects.xmlos.encoding";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String[] escapeString = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&apos;"};
    private static final String[] specialChars = new String[]{"&", "<", ">", "\"", "'"};
    private final String charset;
    private final File directory;
    private final NakedObjectConfiguration configuration;

    public static String getValueWithSpecialsEscaped(String s) {
        String result = s;
        for (int i = 0; i < specialChars.length; ++i) {
            String special = specialChars[i];
            int pos = -1;
            while ((pos = result.indexOf(special, pos + 1)) >= 0) {
                result = result.substring(0, pos) + escapeString[i] + result.substring(pos + special.length());
            }
        }
        return result;
    }

    public XmlFile(NakedObjectConfiguration configuration, String directory) {
        this.configuration = configuration;
        this.directory = new File(directory);
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        this.charset = this.configuration.getString(ENCODING_PROPERTY, DEFAULT_ENCODING);
    }

    public File getDirectory() {
        return this.directory;
    }

    private File file(String fileName) {
        return new File(this.directory, fileName + ".xml");
    }

    public void writeXml(String name, StringBuffer buf) {
        try {
            OutputStreamWriter pw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file(name)), this.charset);
            pw.write("<?xml version=\"1.0\" encoding=\"" + this.charset + "\" ?>\n");
            pw.write("\n");
            pw.write(buf.toString());
            pw.write("\n");
            pw.close();
        }
        catch (IOException e) {
            throw new NakedObjectException("Problems writing data files", (Throwable)e);
        }
    }

    public boolean parse(ContentHandler handler, String fileName) {
        XMLReader parser;
        try {
            parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            try {
                parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException e2) {
                try {
                    parser = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException failed) {
                    throw new NakedObjectException("Couldn't locate a SAX parser");
                }
            }
        }
        try {
            parser.setContentHandler(handler);
            parser.parse(new InputSource(new InputStreamReader((InputStream)new FileInputStream(this.file(fileName)), this.charset)));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new NakedObjectException("Error reading XML file", (Throwable)e);
        }
        catch (SAXParseException e) {
            throw new NakedObjectException("Error while parsing: " + e.getMessage() + " in " + this.file(fileName) + ")", (Throwable)e);
        }
        catch (SAXException e) {
            throw new NakedObjectException("Error in file " + this.file(fileName) + " ", (Throwable)e);
        }
    }

    public void delete(String fileName) {
        this.file(fileName).delete();
    }

    public boolean isFixturesInstalled() {
        String[] list = this.directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        return list.length > 0;
    }
}

