/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.version;

import java.io.Serializable;
import java.util.Date;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.adapter.version.VersionAbstract;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.Clock;

public class FileVersion
extends VersionAbstract
implements Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Clock clock;

    public static void setClock(Clock clock) {
        FileVersion.clock = clock;
    }

    public FileVersion(String user) {
        this(user, clock.getTime());
    }

    public FileVersion(String user, long sequence) {
        super(user, new Date(sequence));
    }

    public FileVersion(ByteDecoder decoder) {
        super(decoder.getString(), new Date(decoder.getLong()));
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(this.user);
        encoder.add(this.time.getTime());
    }

    protected VersionAbstract next() {
        throw new NotYetImplementedException();
    }

    public boolean different(Version version) {
        if (version instanceof FileVersion) {
            FileVersion other = (FileVersion)version;
            return !this.sameTime(other);
        }
        return false;
    }

    private boolean sameTime(FileVersion other) {
        return this.time.getTime() == other.time.getTime();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileVersion) {
            return this.sameTime((FileVersion)obj);
        }
        return false;
    }

    public long getSequence() {
        return this.time.getTime();
    }

    public String sequence() {
        return Long.toString(this.getSequence(), 16);
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("sequence", this.time.getTime());
        str.append("time", (Object)this.time);
        str.append("user", this.user);
        return str.toString();
    }
}

