/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.profilestore;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoderBuffer;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlFile;
import org.nakedobjects.plugins.xml.profilestore.UserProfileDataHandler;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.services.ServiceUtil;
import org.nakedobjects.runtime.userprofile.Options;
import org.nakedobjects.runtime.userprofile.PerspectiveEntry;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.nakedobjects.runtime.userprofile.UserProfileStore;

public class XmlUserProfileStore
implements UserProfileStore {
    private static final String XML_DIR = "nakedobjects.xmluserprofile.dir";
    private final XmlFile xmlFile;

    public XmlUserProfileStore(NakedObjectConfiguration configuration) {
        String directory = configuration.getString(XML_DIR, "xml/profiles");
        this.xmlFile = new XmlFile(configuration, directory);
    }

    public UserProfile getUserProfile(String userName) {
        UserProfileDataHandler handler = new UserProfileDataHandler();
        if (this.xmlFile.parse(handler, userName)) {
            return handler.getUserProfile();
        }
        return null;
    }

    public boolean isFixturesInstalled() {
        return this.xmlFile.isFixturesInstalled();
    }

    public void save(String userName, UserProfile userProfile) {
        StringBuffer xml = new StringBuffer();
        xml.append("<profile>\n");
        xml.append("  <options>\n");
        Options options = userProfile.getOptions();
        Iterator names = options.names();
        while (names.hasNext()) {
            String name = (String)names.next();
            xml.append("      <option" + this.attribute("id", name) + ">" + options.value(name) + "</option>\n");
        }
        xml.append("  </options>\n");
        xml.append("  <perspectives>\n");
        for (String perspectiveName : userProfile.list()) {
            PerspectiveEntry perspective = userProfile.getPerspective(perspectiveName);
            xml.append("  <perspective" + this.attribute("name", perspectiveName) + ">\n");
            xml.append("    <services>\n");
            for (Object service : perspective.getServices()) {
                xml.append("      <service " + this.attribute("id", ServiceUtil.id(service)) + "/>\n");
            }
            xml.append("    </services>\n");
            xml.append("    <objects>\n");
            for (Object object : perspective.getObjects()) {
                NakedObject nakedObject = NakedObjectsContext.getPersistenceSession().getAdapterManager().adapterFor(object);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteEncoderBuffer encoder = new ByteEncoderBuffer((OutputStream)out);
                nakedObject.getOid().encode((ByteEncoder)encoder);
            }
            xml.append("    </objects>\n");
            xml.append("  </perspective>\n");
        }
        xml.append("  </perspectives>\n");
        xml.append("</profile>\n");
        this.xmlFile.writeXml(userName, xml);
    }

    private String attribute(String name, String value) {
        return " " + name + "=\"" + value + "\"";
    }
}

