/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore;

import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.Clock;
import org.nakedobjects.plugins.xml.objectstore.internal.commands.XmlCreateObjectCommand;
import org.nakedobjects.plugins.xml.objectstore.internal.commands.XmlDestroyObjectCommand;
import org.nakedobjects.plugins.xml.objectstore.internal.commands.XmlUpdateObjectCommand;
import org.nakedobjects.plugins.xml.objectstore.internal.data.CollectionData;
import org.nakedobjects.plugins.xml.objectstore.internal.data.Data;
import org.nakedobjects.plugins.xml.objectstore.internal.data.DataManager;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ObjectData;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ObjectDataVector;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ReferenceVector;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlDataManager;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlFile;
import org.nakedobjects.plugins.xml.objectstore.internal.services.ServiceManager;
import org.nakedobjects.plugins.xml.objectstore.internal.services.xml.XmlServiceManager;
import org.nakedobjects.plugins.xml.objectstore.internal.version.FileVersion;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistorUtil;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;
import org.nakedobjects.runtime.transaction.PersistenceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectStore
implements ObjectStore {
    private static final Logger LOG = Logger.getLogger(XmlObjectStore.class);
    private static final String XMLOS_DIR = "nakedobjects.xmlos.dir";
    private final DataManager dataManager;
    private final ServiceManager serviceManager;
    private boolean isFixturesInstalled;

    public XmlObjectStore(NakedObjectConfiguration configuration) {
        String directory = configuration.getString(XMLOS_DIR, "xml/objects");
        XmlFile xmlFile = new XmlFile(configuration, directory);
        this.dataManager = new XmlDataManager(xmlFile);
        this.serviceManager = new XmlServiceManager(xmlFile);
        this.serviceManager.loadServices();
    }

    public XmlObjectStore(DataManager dataManager, ServiceManager serviceManager) {
        this.dataManager = dataManager;
        this.serviceManager = serviceManager;
        serviceManager.loadServices();
    }

    public String name() {
        return "XML";
    }

    public void close() {
        LOG.info((Object)("close " + this));
    }

    public void reset() {
    }

    public boolean hasInstances(NakedObjectSpecification cls) {
        LOG.debug((Object)("checking instance of " + cls));
        ObjectData data = new ObjectData(cls, null, null);
        return this.dataManager.numberOfInstances(data) > 0;
    }

    public void open() throws ObjectPersistenceException {
        this.isFixturesInstalled = this.dataManager.isFixturesInstalled();
    }

    public boolean isFixturesInstalled() {
        return this.isFixturesInstalled;
    }

    private void initObject(NakedObject object, ObjectData data) {
        if (object.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            PersistorUtil.start((NakedObject)object, (ResolveState)ResolveState.RESOLVING);
            NakedObjectAssociation[] fields = object.getSpecification().getAssociations();
            for (int i = 0; i < fields.length; ++i) {
                NakedObjectAssociation field = fields[i];
                if (!field.isNotDerived()) continue;
                NakedObjectSpecification fieldSpecification = field.getSpecification();
                if (fieldSpecification.isEncodeable()) {
                    EncodableFacet encoder = (EncodableFacet)fieldSpecification.getFacet(EncodableFacet.class);
                    String valueData = data.value(field.getId());
                    NakedObject value = valueData == null || valueData.equals("NULL") ? null : encoder.fromEncodedString(valueData);
                    ((OneToOneAssociation)field).initAssociation(object, value);
                    continue;
                }
                if (field.isOneToManyAssociation()) {
                    this.initObjectSetupCollection(object, data, field);
                    continue;
                }
                if (!field.isOneToOneAssociation()) continue;
                this.initObjectSetupReference(object, data, field);
            }
            object.setOptimisticLock((Version)data.getVersion());
            PersistorUtil.end((NakedObject)object);
        }
    }

    private void initObjectSetupReference(NakedObject object, ObjectData data, NakedObjectAssociation field) {
        SerialOid referenceOid = (SerialOid)data.get(field.getId());
        LOG.debug((Object)("setting up field " + field + " with " + referenceOid));
        if (referenceOid == null) {
            return;
        }
        Data fieldData = this.dataManager.loadData(referenceOid);
        if (fieldData == null) {
            NakedObject adapter = XmlObjectStore.getPersistenceSession().recreateAdapter((Oid)referenceOid, field.getSpecification());
            if (!adapter.getResolveState().isDestroyed()) {
                adapter.changeState(ResolveState.DESTROYED);
            }
            ((OneToOneAssociation)field).initAssociation(object, adapter);
            LOG.warn((Object)("No data found for " + referenceOid + " so field '" + field.getName() + "' not set in object '" + object.titleString() + "'"));
        } else {
            NakedObject reference = XmlObjectStore.getPersistenceSession().recreateAdapter((Oid)referenceOid, this.specFor(fieldData));
            ((OneToOneAssociation)field).initAssociation(object, reference);
        }
    }

    private void initObjectSetupCollection(NakedObject object, ObjectData data, NakedObjectAssociation field) {
        ReferenceVector refs = (ReferenceVector)data.get(field.getId());
        NakedObject collection = field.get(object);
        if (collection.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            PersistorUtil.start((NakedObject)collection, (ResolveState)ResolveState.RESOLVING);
            int size = refs == null ? 0 : refs.size();
            NakedObject[] elements = new NakedObject[size];
            for (int j = 0; j < size; ++j) {
                SerialOid elementOid = refs.elementAt(j);
                NakedObject adapter = XmlObjectStore.getAdapterManager().getAdapterFor((Oid)elementOid);
                if (adapter == null) {
                    adapter = this.getObject((Oid)elementOid, null);
                }
                elements[j] = adapter;
            }
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
            facet.init(collection, elements);
            PersistorUtil.end((NakedObject)collection);
        }
    }

    public void startTransaction() {
        LOG.debug((Object)"start transaction");
    }

    public void endTransaction() {
        LOG.debug((Object)"end transaction");
    }

    public void abortTransaction() {
        LOG.debug((Object)"transaction aborted");
    }

    public CreateObjectCommand createCreateObjectCommand(NakedObject object) {
        return new XmlCreateObjectCommand(object, this.dataManager);
    }

    public SaveObjectCommand createSaveObjectCommand(NakedObject object) {
        return new XmlUpdateObjectCommand(object, this.dataManager);
    }

    public DestroyObjectCommand createDestroyObjectCommand(NakedObject object) {
        return new XmlDestroyObjectCommand(object, this.dataManager);
    }

    public void execute(List<PersistenceCommand> commands) {
        LOG.debug((Object)"start execution of transaction");
        for (PersistenceCommand command : commands) {
            command.execute(null);
        }
        LOG.debug((Object)"end execution");
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) {
        LOG.debug((Object)("getObject " + oid));
        Data data = this.dataManager.loadData((SerialOid)oid);
        LOG.debug((Object)("  data read " + data));
        if (!(data instanceof ObjectData)) {
            if (data instanceof CollectionData) {
                throw new NakedObjectException();
            }
            throw new ObjectNotFoundException(oid);
        }
        NakedObject object = this.recreateObject((ObjectData)data);
        return object;
    }

    public void resolveField(NakedObject object, NakedObjectAssociation field) {
        NakedObject reference = field.get(object);
        this.resolveImmediately(reference);
    }

    public void resolveImmediately(NakedObject object) {
        ObjectData data = (ObjectData)this.dataManager.loadData((SerialOid)object.getOid());
        Assert.assertNotNull((String)"Not able to read in data during resolve", (Object)object, (Object)data);
        this.initObject(object, data);
    }

    private NakedObject recreateObject(ObjectData data) {
        SerialOid oid = data.getOid();
        NakedObjectSpecification spec = this.specFor(data);
        NakedObject object = XmlObjectStore.getPersistenceSession().recreateAdapter((Oid)oid, spec);
        this.initObject(object, data);
        return object;
    }

    public NakedObject[] getInstances(PersistenceQuery persistenceQuery) {
        if (!(persistenceQuery instanceof PersistenceQueryBuiltIn)) {
            throw new IllegalArgumentException(MessageFormat.format("Provided PersistenceQuery not supported; was {0}; the XML object store only supports {1}", persistenceQuery.getClass().getName(), PersistenceQueryBuiltIn.class.getName()));
        }
        PersistenceQueryBuiltIn builtIn = (PersistenceQueryBuiltIn)persistenceQuery;
        LOG.debug((Object)("getInstances of " + builtIn.getSpecification() + " where " + builtIn));
        ObjectData patternData = new ObjectData(builtIn.getSpecification(), null, null);
        NakedObject[] instances = this.getInstances(patternData, builtIn);
        return instances;
    }

    private NakedObject[] getInstances(ObjectData patternData, PersistenceQueryBuiltIn persistenceQuery) {
        ObjectDataVector data = this.dataManager.getInstances(patternData);
        NakedObject[] instances = new NakedObject[data.size()];
        int count = 0;
        for (int i = 0; i < data.size(); ++i) {
            ObjectData instanceData = data.element(i);
            LOG.debug((Object)("instance data " + instanceData));
            SerialOid oid = instanceData.getOid();
            NakedObjectSpecification spec = this.specFor(instanceData);
            NakedObject instance = XmlObjectStore.getPersistenceSession().recreateAdapter((Oid)oid, spec);
            this.initObject(instance, instanceData);
            if (persistenceQuery != null && !persistenceQuery.matches(instance)) continue;
            instances[count++] = instance;
        }
        NakedObject[] array = new NakedObject[count];
        System.arraycopy(instances, 0, array, 0, count);
        return array;
    }

    private NakedObjectSpecification specFor(Data data) {
        return XmlObjectStore.getSpecificationLoader().loadSpecification(data.getTypeName());
    }

    public Oid getOidForService(String name) {
        return this.serviceManager.getOidForService(name);
    }

    public void registerService(String name, Oid oid) {
        this.serviceManager.registerService(name, oid);
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("Business Objects");
        debug.appendln(this.dataManager.getDebugData());
    }

    public String debugTitle() {
        return "XML Object Store";
    }

    public void setClock(Clock clock) {
        FileVersion.setClock(clock);
    }

    protected static SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private static AdapterManager getAdapterManager() {
        return XmlObjectStore.getPersistenceSession().getAdapterManager();
    }

    protected static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }
}

