/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.data.xml;

import java.util.Vector;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.xml.objectstore.internal.data.CollectionData;
import org.nakedobjects.plugins.xml.objectstore.internal.data.Data;
import org.nakedobjects.plugins.xml.objectstore.internal.data.DataManager;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ObjectData;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ObjectDataVector;
import org.nakedobjects.plugins.xml.objectstore.internal.data.PersistorException;
import org.nakedobjects.plugins.xml.objectstore.internal.data.ReferenceVector;
import org.nakedobjects.plugins.xml.objectstore.internal.data.xml.XmlFile;
import org.nakedobjects.plugins.xml.objectstore.internal.version.FileVersion;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDataManager
implements DataManager {
    private final XmlFile xmlFile;

    public XmlDataManager(XmlFile xmlFile) {
        this.xmlFile = xmlFile;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isFixturesInstalled() {
        return this.xmlFile.isFixturesInstalled();
    }

    @Override
    public Data loadData(SerialOid oid) {
        DataHandler handler = new DataHandler();
        this.xmlFile.parse(handler, this.filename(oid));
        if (handler.object != null) {
            return handler.object;
        }
        return handler.collection;
    }

    @Override
    public ObjectDataVector getInstances(ObjectData pattern) {
        Vector<SerialOid> instances = this.loadInstances(pattern.getSpecification());
        if (instances == null) {
            return new ObjectDataVector();
        }
        ObjectDataVector matches = new ObjectDataVector();
        for (SerialOid oid : instances) {
            ObjectData instanceData = (ObjectData)this.loadData(oid);
            if (instanceData == null) {
                throw new NakedObjectException("No data found for " + oid + " (possible missing file)");
            }
            if (!this.matchesPattern(pattern, instanceData)) continue;
            matches.addElement(instanceData);
        }
        return matches;
    }

    @Override
    public int numberOfInstances(ObjectData pattern) {
        return this.getInstances(pattern).size();
    }

    private Vector<SerialOid> loadInstances(NakedObjectSpecification noSpec) {
        InstanceHandler handler = new InstanceHandler();
        this.parseSpecAndSubclasses(handler, noSpec);
        return handler.instances;
    }

    private void parseSpecAndSubclasses(InstanceHandler handler, NakedObjectSpecification noSpec) {
        this.parseIfNotAbstract(noSpec, handler);
        for (NakedObjectSpecification subSpec : noSpec.subclasses()) {
            this.parseSpecAndSubclasses(handler, subSpec);
        }
    }

    private void parseIfNotAbstract(NakedObjectSpecification noSpec, InstanceHandler handler) {
        if (noSpec.isAbstract()) {
            return;
        }
        this.xmlFile.parse(handler, noSpec.getFullName());
    }

    protected boolean matchesPattern(ObjectData patternData, ObjectData candidateData) {
        if (patternData == null || candidateData == null) {
            throw new NullPointerException("Can't match on nulls " + patternData + " " + candidateData);
        }
        if (!candidateData.getSpecification().isOfType(patternData.getSpecification())) {
            return false;
        }
        for (String field : patternData.fields()) {
            Object patternFieldValue = patternData.get(field);
            Object candidateFieldValue = candidateData.get(field);
            if (candidateFieldValue instanceof ReferenceVector) {
                ReferenceVector patternElements = (ReferenceVector)patternFieldValue;
                for (int i = 0; i < patternElements.size(); ++i) {
                    SerialOid requiredElement = patternElements.elementAt(i);
                    boolean requiredFound = false;
                    ReferenceVector testElements = (ReferenceVector)candidateFieldValue;
                    for (int j = 0; j < testElements.size(); ++j) {
                        if (!requiredElement.equals(testElements.elementAt(j))) continue;
                        requiredFound = true;
                        break;
                    }
                    if (requiredFound) continue;
                    return false;
                }
                continue;
            }
            if (patternFieldValue.equals(candidateFieldValue)) continue;
            return false;
        }
        return true;
    }

    protected long nextId() throws PersistorException {
        NumberHandler handler = new NumberHandler();
        this.xmlFile.parse(handler, "oid");
        StringBuffer data = new StringBuffer();
        data.append("<number>");
        data.append(handler.value + 1L);
        data.append("</number>");
        this.xmlFile.writeXml("oid", data);
        return handler.value + 1L;
    }

    @Override
    public final void insertObject(ObjectData data) {
        if (data.getOid() == null) {
            throw new IllegalArgumentException("Oid must be non-null");
        }
        this.writeInstanceToItsDataFile(data);
        this.addReferenceToInstancesFile(data.getOid(), data.getSpecification());
    }

    private void addReferenceToInstancesFile(SerialOid oid, NakedObjectSpecification noSpec) {
        Vector<SerialOid> instances = this.loadInstances(noSpec);
        instances.addElement(oid);
        this.writeInstanceFile(noSpec, instances);
    }

    @Override
    public final void remove(SerialOid oid) throws ObjectNotFoundException, ObjectPersistenceException {
        Data data = this.loadData(oid);
        this.removeReferenceFromInstancesFile(oid, data.getSpecification());
        this.deleteData(oid);
    }

    private void deleteData(SerialOid oid) {
        this.xmlFile.delete(this.filename(oid));
    }

    private void removeReferenceFromInstancesFile(SerialOid oid, NakedObjectSpecification noSpec) {
        Vector<SerialOid> instances = this.loadInstances(noSpec);
        instances.removeElement(oid);
        this.writeInstanceFile(noSpec, instances);
    }

    private void writeInstanceFile(NakedObjectSpecification noSpec, Vector<SerialOid> instances) {
        this.writeInstanceFile(noSpec.getFullName(), instances);
    }

    private void writeInstanceFile(String name, Vector<SerialOid> instances) {
        StringBuffer data = new StringBuffer();
        data.append("<instances name=\"" + name + "\">\n");
        for (SerialOid elementAt : instances) {
            data.append("  <instance id=\"" + this.encodedOid(elementAt) + "\"/>\n");
        }
        data.append("</instances>");
        this.xmlFile.writeXml(name, data);
    }

    @Override
    public final void save(Data data) {
        this.writeInstanceToItsDataFile(data);
    }

    private void writeInstanceToItsDataFile(Data data) {
        StringBuffer xml = new StringBuffer();
        boolean isObject = data instanceof ObjectData;
        String tag = isObject ? "naked-object" : "collection";
        xml.append("<" + tag);
        xml.append(this.attribute("type", data.getTypeName()));
        xml.append(this.attribute("id", "" + this.encodedOid(data.getOid())));
        xml.append(this.attribute("user", "" + NakedObjectsContext.getAuthenticationSession().getUserName()));
        long sequence = data.getVersion().getSequence();
        String sequenceString = Long.toHexString(sequence).toUpperCase();
        xml.append(this.attribute("ver", "" + sequenceString));
        xml.append(">\n");
        if (isObject) {
            this.writeObject(data, xml);
        } else {
            this.writeCollection(data, xml);
        }
        xml.append("</" + tag + ">\n");
        this.xmlFile.writeXml(this.filename(data.getOid()), xml);
    }

    private void writeObject(Data data, StringBuffer xml) {
        ObjectData object = (ObjectData)data;
        for (String field : object.fields()) {
            this.writeField(xml, object, field);
        }
    }

    private void writeField(StringBuffer xml, ObjectData object, String field) {
        Object entry = object.get(field);
        if (entry instanceof SerialOid) {
            this.writeAssociationField(xml, field, entry);
        } else if (entry instanceof ReferenceVector) {
            this.writeMultipleAssociationField(xml, field, entry);
        } else {
            this.writeValueField(xml, field, entry);
        }
    }

    private void writeAssociationField(StringBuffer xml, String field, Object entry) {
        Assert.assertFalse((boolean)((SerialOid)entry).isTransient());
        xml.append("  <association field=\"" + field + "\" ");
        xml.append("ref=\"" + this.encodedOid((SerialOid)entry) + "\"/>\n");
    }

    private void writeMultipleAssociationField(StringBuffer xml, String field, Object entry) {
        ReferenceVector references = (ReferenceVector)entry;
        int size = references.size();
        if (size > 0) {
            xml.append("  <multiple-association field=\"" + field + "\" ");
            xml.append(">\n");
            for (int i = 0; i < size; ++i) {
                SerialOid oid = references.elementAt(i);
                Assert.assertFalse((String)"transient oid", (Object)oid, (boolean)oid.isTransient());
                xml.append("    <element ");
                xml.append("ref=\"" + this.encodedOid(oid) + "\"/>\n");
            }
            xml.append("  </multiple-association>\n");
        }
    }

    private void writeValueField(StringBuffer xml, String field, Object entry) {
        xml.append("  <value field=\"" + field + "\">");
        xml.append(XmlFile.getValueWithSpecialsEscaped(entry.toString()));
        xml.append("</value>\n");
    }

    private void writeCollection(Data data, StringBuffer xml) {
        CollectionData collection = (CollectionData)data;
        ReferenceVector refs = collection.references();
        for (int i = 0; i < refs.size(); ++i) {
            SerialOid oid = refs.elementAt(i);
            xml.append("  <element ");
            xml.append("ref=\"" + this.encodedOid(oid) + "\"/>\n");
        }
    }

    private String attribute(String name, String value) {
        return " " + name + "=\"" + value + "\"";
    }

    private String filename(SerialOid oid) {
        return this.encodedOid(oid);
    }

    private String encodedOid(SerialOid oid) {
        return Long.toHexString(oid.getSerialNo()).toUpperCase();
    }

    @Override
    public String getDebugData() {
        return "Data directory " + this.xmlFile.getDirectory();
    }

    private class NumberHandler
    extends DefaultHandler {
        boolean captureValue = false;
        long value = 0L;

        private NumberHandler() {
        }

        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            if (this.captureValue) {
                this.value = Long.valueOf(new String(arg0, arg1, arg2), 16);
            }
        }

        public void startElement(String ns, String name, String tagName, Attributes attrs) throws SAXException {
            this.captureValue = tagName.equals("number");
        }
    }

    private class InstanceHandler
    extends DefaultHandler {
        Vector<SerialOid> instances = new Vector();

        private InstanceHandler() {
        }

        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void startElement(String ns, String name, String tagName, Attributes attrs) throws SAXException {
            if (tagName.equals("instance")) {
                long oid = Long.valueOf(attrs.getValue("id"), 16);
                this.instances.addElement(SerialOid.createPersistent((long)oid));
            }
        }
    }

    private class DataHandler
    extends DefaultHandler {
        CollectionData collection;
        StringBuffer data = new StringBuffer();
        String fieldName;
        ObjectData object;

        private DataHandler() {
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            this.data.append(new String(ch, start, end));
        }

        public void endElement(String ns, String name, String tagName) throws SAXException {
            if (this.object != null && tagName.equals("value")) {
                String value = this.data.toString();
                this.object.set(this.fieldName, value);
            }
        }

        public void startElement(String ns, String name, String tagName, Attributes attributes) throws SAXException {
            if (this.object != null) {
                if (tagName.equals("value")) {
                    this.fieldName = attributes.getValue("field");
                    this.data.setLength(0);
                } else if (tagName.equals("association")) {
                    String fieldName = attributes.getValue("field");
                    long id = Long.valueOf(attributes.getValue("ref"), 16);
                    this.object.set(fieldName, SerialOid.createPersistent((long)id));
                } else if (tagName.equals("element")) {
                    long id = Long.valueOf(attributes.getValue("ref"), 16);
                    this.object.addElement(this.fieldName, SerialOid.createPersistent((long)id));
                } else if (tagName.equals("multiple-association")) {
                    this.fieldName = attributes.getValue("field");
                    this.object.initCollection(this.fieldName);
                }
            } else if (this.collection != null) {
                if (tagName.equals("element")) {
                    long id = Long.valueOf(attributes.getValue("ref"), 16);
                    this.collection.addElement(SerialOid.createPersistent((long)id));
                }
            } else if (tagName.equals("naked-object")) {
                String typeName = attributes.getValue("type");
                long version = Long.valueOf(attributes.getValue("ver"), 16);
                String user = attributes.getValue("user");
                long id = Long.valueOf(attributes.getValue("id"), 16);
                NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(typeName);
                SerialOid oid = SerialOid.createPersistent((long)id);
                this.object = new ObjectData(spec, oid, new FileVersion(user, version));
            } else if (tagName.equals("collection")) {
                String type = attributes.getValue("type");
                long version = Long.valueOf(attributes.getValue("ver"), 16);
                String user = attributes.getValue("user");
                long id = Long.valueOf(attributes.getValue("id"), 16);
                NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(type);
                SerialOid oid = SerialOid.createPersistent((long)id);
                this.collection = new CollectionData(spec, oid, new FileVersion(user, version));
            } else {
                throw new SAXException("Invalid data");
            }
        }
    }
}

