/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;

public class CopyXmlObjectStore {
    public static void main(String[] args) {
        String workingDirectory = args[0];
        String testDirectory = args[1];
        CopyXmlObjectStore.copyAllFiles(testDirectory, workingDirectory);
    }

    private static void copyAllFiles(String testDirectory, String workingDirectory) {
        File from = new File(testDirectory);
        File to = new File(workingDirectory);
        if (!to.exists()) {
            to.mkdirs();
        }
        if (to.isFile()) {
            throw new NakedObjectException("To directory is actually a file " + to.getAbsolutePath());
        }
        String[] list = from.list();
        for (int i = 0; i < list.length; ++i) {
            CopyXmlObjectStore.copyFile(new File(from, list[i]), new File(to, list[i]));
        }
    }

    private static void copyFile(File from, File to) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(from));
            bos = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = bis.read(buffer)) > 0) {
                ((BufferedOutputStream)bos).write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new NakedObjectException("Error copying file " + from.getAbsolutePath() + " to " + to.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ignore) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

