/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.profilestore;

import java.util.List;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.services.ServiceUtil;
import org.nakedobjects.runtime.userprofile.PerspectiveEntry;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UserProfileDataHandler
extends DefaultHandler {
    private final StringBuffer data = new StringBuffer();
    private final UserProfile userProfile = new UserProfile();
    private String optionName;
    private boolean isProfile;
    private boolean isOptions;
    private boolean isPerspectives;
    private PerspectiveEntry perspective;
    private boolean isServices;
    private boolean isObjects;

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        this.data.append(new String(ch, start, end));
    }

    public void endElement(String ns, String name, String tagName) throws SAXException {
        if (tagName.equals("options")) {
            this.isOptions = false;
        } else if (tagName.equals("perspectives")) {
            this.isPerspectives = false;
        } else if (tagName.equals("perspective")) {
            this.perspective = null;
        } else if (tagName.equals("services")) {
            this.isServices = false;
        } else if (tagName.equals("objects")) {
            this.isObjects = false;
        } else if (tagName.equals("option")) {
            String value = this.data.toString();
            this.userProfile.addToOptions(this.optionName, value);
        } else if (tagName.equals("name")) {
            String value = this.data.toString();
            System.out.println(value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String ns, String name, String tagName, Attributes attributes) throws SAXException {
        if (this.isProfile) {
            if (this.isOptions) {
                if (!tagName.equals("option")) throw new SAXException("Invalid element in options: " + tagName);
                this.optionName = attributes.getValue("id");
                this.data.setLength(0);
            } else if (this.isPerspectives) {
                if (this.perspective != null) {
                    if (this.isServices) {
                        if (!tagName.equals("service")) throw new SAXException("Invalid element in services: " + tagName);
                        String serviceId = attributes.getValue("id");
                        List serviceObjects = NakedObjectsContext.getServices();
                        for (Object service : serviceObjects) {
                            if (!ServiceUtil.id(service).equals(serviceId)) continue;
                            this.perspective.addToServices(service);
                            break;
                        }
                    } else if (!this.isObjects) {
                        if (tagName.equals("services")) {
                            this.isServices = true;
                        } else {
                            if (!tagName.equals("objects")) throw new SAXException("Invalid element in perspective: " + tagName);
                            this.isObjects = true;
                        }
                    }
                } else {
                    if (!tagName.equals("perspective")) throw new SAXException("Invalid element in perspectives: " + tagName);
                    this.perspective = this.userProfile.newPerspective(attributes.getValue("name"));
                }
            } else if (tagName.equals("options")) {
                this.isOptions = true;
            } else {
                if (!tagName.equals("perspectives") || this.isOptions) throw new SAXException("Invalid element in profile: " + tagName);
                this.isPerspectives = true;
            }
        }
        if (!tagName.equals("profile")) return;
        this.isProfile = true;
    }
}

