/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xml.objectstore.internal.version;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.adapter.version.VersionUserAndTimeAbstract;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.xml.objectstore.internal.clock.Clock;

public class FileVersion
extends VersionUserAndTimeAbstract
implements Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Clock clock;

    public static void setClock(Clock clock) {
        FileVersion.clock = clock;
    }

    public FileVersion(String user) {
        this(user, clock.getTime());
    }

    public FileVersion(String user, long sequence) {
        super(user, new Date(sequence));
        this.initialized();
    }

    public FileVersion(DataInputExtended input) throws IOException {
        super(input);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
    }

    private void initialized() {
    }

    public long getSequence() {
        return this.getTime().getTime();
    }

    public String sequence() {
        return Long.toString(this.getSequence(), 16);
    }

    public boolean different(Version version) {
        if (version instanceof FileVersion) {
            FileVersion other = (FileVersion)version;
            return !this.sameTime(other);
        }
        return false;
    }

    private boolean sameTime(FileVersion other) {
        return this.getTime().getTime() == other.getTime().getTime();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileVersion) {
            return this.sameTime((FileVersion)obj);
        }
        return false;
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("sequence", this.getTime().getTime());
        str.append("time", (Object)this.getTime());
        str.append("user", this.getUser());
        return str.toString();
    }
}

