package org.nakedobjects.plugins.remoting.command.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.nakedobjects.plugins.remoting.command.marshal.xstream.XStreamMarshaller;
import org.nakedobjects.plugins.remoting.command.server.ServerConnection;
import org.nakedobjects.plugins.remoting.command.server.ServerConnectionImpl;
import org.nakedobjects.plugins.remoting.command.shared.marshal.ConnectionException;
import org.nakedobjects.plugins.remoting.command.transport.socket.server.ServerListenerAbstract;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;


public class XStreamOverSocketsServerListener extends ServerListenerAbstract {
    @Override
    protected ServerConnection createClientConnection(
            final InputStream input,
            final OutputStream output,
            final ServerFacade distribution) {
        XStreamMarshaller serverMarshaller = new XStreamMarshaller();
        try {
            serverMarshaller.openStreams(input, output);
        } catch (IOException e) {
            throw new ConnectionException(e);
        }
        return new ServerConnectionImpl(distribution, serverMarshaller);
    }
}

// Copyright (c) Naked Objects Group Ltd.
