/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.xstream.shared;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.exchange.Request;
import org.nakedobjects.remoting.protocol.IllegalRequestException;
import org.nakedobjects.remoting.protocol.MarshallerAbstract;
import org.nakedobjects.remoting.transport.ConnectionException;
import org.nakedobjects.remoting.transport.Transport;

public class XStreamMarshaller
extends MarshallerAbstract {
    private static final Logger LOG = Logger.getLogger(XStreamMarshaller.class);
    private final XStream xstream = new XStream();
    private ObjectInputStream input;
    private ObjectOutputStream output;

    public XStreamMarshaller(NakedObjectConfiguration configuration, Transport transport) {
        super(configuration, transport);
    }

    public void connect() throws IOException {
        super.connect();
        this.output = new ObjectOutputStream(this.getTransport().getOutputStream());
        this.input = new ObjectInputStream(this.getTransport().getInputStream());
    }

    public Object request(Request request) throws IOException {
        String requestData = this.xstream.toXML((Object)request);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("sending " + requestData.length() + " bytes of data"));
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sending request \n" + requestData));
            }
            try {
                this.output.writeObject(requestData);
            }
            catch (SocketException e) {
                this.reconnect();
                this.output.writeObject(requestData);
            }
            this.output.flush();
            String responseData = (String)this.input.readObject();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("response received: \n" + responseData));
            }
            return this.xstream.fromXML(responseData);
        }
        catch (StreamCorruptedException e) {
            try {
                int available = this.input.available();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("error in reading; skipping bytes: " + available));
                }
                this.input.skip(available);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionException("Failed request", (Throwable)e);
        }
    }

    public Request readRequest() throws IOException {
        try {
            String requestData = (String)this.input.readObject();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("request received \n" + requestData));
            }
            Request request = (Request)this.xstream.fromXML(requestData);
            return request;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalRequestException("unknown class received; closing connection: " + e.getMessage(), (Throwable)e);
        }
    }

    public void sendError(NakedObjectException exception) throws IOException {
        String responseData = this.xstream.toXML((Object)exception);
        this.sendData(responseData);
    }

    public void sendResponse(Object response) throws IOException {
        String responseData = this.xstream.toXML(response);
        this.sendData(responseData);
    }

    private void sendData(String responseData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("send response \n" + responseData));
        }
        this.output.writeObject(responseData);
        this.output.flush();
    }
}

