package org.nakedobjects.plugins.remoting.client.authorization;

import java.util.HashMap;
import java.util.Map;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.runtime.authorization.AuthorizationManager;


public class ProxyAuthorizationManager implements AuthorizationManager {

    private final ServerFacade connection;
    private final Map<String,Boolean> visibilityCache = new HashMap<String,Boolean>();
    private final Map<String,Boolean> usabilityCache = new HashMap<String,Boolean>();

    public ProxyAuthorizationManager(final ServerFacade connection) {
        this.connection = connection;
    }

    private boolean remoteAuthUsability(final AuthenticationSession session, final String idString) {
        return connection.authoriseUsability(session, idString);
    }

    private boolean remoteAuthVisibility(final AuthenticationSession session, final String idString) {
        return connection.authoriseVisibility(session, idString);
    }

    public boolean isUsable(final AuthenticationSession session, final Identifier identifier) {
        return isAuthorised(session, identifier, usabilityCache);
    }

    public boolean isVisible(final AuthenticationSession session, final Identifier identifier) {
        return isAuthorised(session, identifier, visibilityCache);
    }

    private boolean isAuthorised(final AuthenticationSession session, final Identifier identifier, final Map<String,Boolean> cache) {
        final String idString = identifier.toIdentityString(Identifier.CLASS_NAME_PARMS);
        if (!cache.containsKey(idString)) {
            final Boolean allow = cache == usabilityCache ? remoteAuthUsability(session, idString) : remoteAuthVisibility(session,
                    idString);
            cache.put(idString, allow);
            return allow;
        }
        return ((Boolean) cache.get(idString)).booleanValue();
    }

    public void init() {}

    public void shutdown() {}
}
