package org.nakedobjects.plugins.remoting.client.facetdecorator;

import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorAbstract;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.plugins.remoting.client.facets.ActionInvocationFacetWrapProxy;
import org.nakedobjects.plugins.remoting.client.facets.CollectionAddToFacetWrapProxy;
import org.nakedobjects.plugins.remoting.client.facets.CollectionRemoveFromFacetWrapProxy;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoder;


public class ProxyFacetDecorator  extends FacetDecoratorAbstract {
    private final ServerFacade connection;
    private final ObjectEncoder encoder;

    public ProxyFacetDecorator(final ServerFacade connection, final ObjectEncoder encoder) {
        this.connection = connection;
        this.encoder = encoder;
    }

    public Facet decorate(final Facet facet, final FacetHolder holder) {
        final NakedObjectAction peer = (NakedObjectAction) holder;
        if (facet.facetType() == ActionInvocationFacet.class) {
            final ActionInvocationFacet actionInvocationFacet = (ActionInvocationFacet) facet;
            return new ActionInvocationFacetWrapProxy(actionInvocationFacet, connection, encoder, peer);
        }

        if (facet.facetType() == CollectionAddToFacet.class) {
            final CollectionAddToFacet collectionAddToFacet = (CollectionAddToFacet) facet;
            return new CollectionAddToFacetWrapProxy(collectionAddToFacet, connection, encoder, peer.getIdentifier()
                    .getMemberName());
        }

        if (facet.facetType() == CollectionRemoveFromFacet.class) {
            final CollectionRemoveFromFacet collectionRemoveFromFacet = (CollectionRemoveFromFacet) facet;
            return new CollectionRemoveFromFacetWrapProxy(collectionRemoveFromFacet, connection, encoder, peer.getIdentifier()
                    .getMemberName());
        }

        return facet;
    }

    @SuppressWarnings("unchecked")
	public Class<? extends Facet>[] forFacetTypes() {
        return new Class[] { ActionInvocationFacet.class, CollectionAddToFacet.class, CollectionRemoveFromFacet.class };
    }
}

// Copyright (c) Naked Objects Group Ltd.
