package org.nakedobjects.plugins.remoting.client.facets;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacetAbstract;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;


/**
 * A reflection peer for changing one-to-many fields remotely, instead of on the local machine. Any requests
 * to add or remove elements from the field will be passed over the network to the server for completion. Only
 * requests on persistent objects are passed to the server; on a transient object the request will always be
 * dealt with locally.
 * 
 * <p>
 * If any of the objects involved have been changed on the server by another process then a
 * ConcurrencyException will be passed back to the client and re-thrown.
 * </p>
 */
public final class CollectionAddToFacetWrapProxy extends CollectionAddToFacetAbstract implements
        DecoratingFacet<CollectionAddToFacet> {

    private final static Logger LOG = Logger.getLogger(CollectionAddToFacetWrapProxy.class);
    private final ServerFacade connection;
    private final ObjectEncoder encoder;
    private final CollectionAddToFacet underlyingFacet;
    private final String name;

    public CollectionAddToFacetWrapProxy(
            final CollectionAddToFacet underlyingFacet,
            final ServerFacade connection,
            final ObjectEncoder encoder,
            final String name) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
        this.connection = connection;
        this.encoder = encoder;
        this.name = name;
    }

    public CollectionAddToFacet getDecoratedFacet() {
        return underlyingFacet;
    }

    public void add(final NakedObject inObject, final NakedObject referencedAdapter) {
        if (ProxyUtil.executeRemotely(inObject)) {
            try {
                final IdentityData targetReference = encoder.encodeIdentityData(inObject);
                final IdentityData associateReference = encoder.encodeIdentityData(referencedAdapter);
                ObjectData[] updates;
                updates = connection.setAssociation(NakedObjectsContext.getAuthenticationSession(), name, targetReference, associateReference);
                ProxyUtil.updateChangedObjects(updates, encoder);
            } catch (final ConcurrencyException e) {
                throw ProxyUtil.concurrencyException(e);
            } catch (final NakedObjectException e) {
                LOG.error("remote exception: " + e.getMessage(), e);
                throw e;
            }
        } else {
            underlyingFacet.add(inObject, referencedAdapter);
        }
    }

}
// Copyright (c) Naked Objects Group Ltd.
