package org.nakedobjects.plugins.remoting.command.client.facetdecorator;


import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.nakedobjects.metamodel.commons.ensure.Ensure.ensureThatArg;

import java.util.Properties;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.plugins.remoting.client.authentication.AuthenticationManagerProxy;
import org.nakedobjects.plugins.remoting.client.authorization.ProxyAuthorizationFacetDecorator;
import org.nakedobjects.plugins.remoting.client.facetdecorator.ProxyFacetDecoratorFromRemotingCommandProject;
import org.nakedobjects.plugins.remoting.client.persistence.ClientSideTransactionManager;
import org.nakedobjects.plugins.remoting.client.persistence.PersistenceSessionProxy;
import org.nakedobjects.plugins.remoting.client.persistence.ProxyPersistenceSessionFactory;
import org.nakedobjects.plugins.remoting.command.shared.util.SharedUtil;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoderDefault;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authorization.AuthorizationFacetDecorator;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstallerAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerProxy;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.remoting.ClientConnectionInstaller;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;


public abstract class ProxyDecoratorInstallerAbstract extends PersistenceMechanismInstallerAbstract implements ClientConnectionInstaller {
    
    @SuppressWarnings("unused")
	private static final Logger LOG = Logger.getLogger(ProxyDecoratorInstallerAbstract.class);
    
    private ServerFacade serverFacade;
    private ObjectEncoderDefault encoder;

    
    ///////////////////////////////////////////////////////////////////
    // ServerFacade, RemoteProperties
    ///////////////////////////////////////////////////////////////////

    private ServerFacade getServerFacade() {
        if (serverFacade == null) {
            serverFacade = createServerFacade();
            serverFacade.init();
        }
        return serverFacade;
    }

    /**
     * Hook method called by {@link #getServerFacade()} as required.
     */
    protected abstract ServerFacade createServerFacade();


    public Properties getRemoteProperties() {
        // TODO sort out somewhere for properties to be accessed and then use them here
//        return getServerFacade().getProperties();
        return new Properties();
    }

    ///////////////////////////////////////////////////////////////////
    // Encoders
    ///////////////////////////////////////////////////////////////////

    public void installEncoders(final NakedObjectConfiguration configuration) {
    	if (encoder == null) {
    		encoder = SharedUtil.createDefaultEncoderAndAddCriteriaStrategies(configuration);
    	}
    }

	protected ObjectEncoderDefault getEncoder() {
		// have moved initialization forward into installEncoders; previously it was only
		// partially done here (the creation of the encoder, but not the setting up of
		// criteria strategies.
    	if (encoder == null) {
    		throw new IllegalStateException("No encoder; should have been setup by installEncoders");
    	}
        return encoder;
    }

	public AuthenticationManager createAuthenticationManager() {
        return new AuthenticationManagerProxy(getServerFacade());
    }
    

    ///////////////////////////////////////////////////////////////////
    // Decorator 
    ///////////////////////////////////////////////////////////////////

    public FacetDecorator createDecorator() {
        final ServerFacade connection = getServerFacade();
        final ObjectEncoder encoder = getEncoder();

        final AuthorizationFacetDecorator authorisationFacetDecorator = new ProxyAuthorizationFacetDecorator(connection);

        final ProxyFacetDecoratorFromRemotingCommandProject proxyFacetDecorator = 
            new ProxyFacetDecoratorFromRemotingCommandProject(connection, encoder, authorisationFacetDecorator);

        return proxyFacetDecorator;
    }

    ///////////////////////////////////////////////////////////////////
    // Create PersistenceSession
    ///////////////////////////////////////////////////////////////////

    public PersistenceSessionFactory createPersistenceSessionFactory(final DeploymentType deploymentType) {
        return new ProxyPersistenceSessionFactory(deploymentType, this);
    }


	protected PersistenceSession createPersistenceSession(
			final PersistenceSessionFactory persistenceSessionFactory,
			final AdapterManagerExtended adapterManager,
			final AdapterFactory adapterFactory,
			final ObjectFactory objectFactory,
			final OidGenerator oidGenerator,
			final ServicesInjector servicesInjector) {

        installEncoders(getConfiguration());

        final PersistenceSessionProxy persistenceSession = 
            new PersistenceSessionProxy(
                    persistenceSessionFactory, 
                    adapterFactory, objectFactory, servicesInjector, oidGenerator, adapterManager, 
                    getServerFacade(), getEncoder());

        NakedObjectTransactionManager transactionManager = 
            createTransactionManager(getConfiguration(), persistenceSession.getAdapterManager(), persistenceSession);
        
        ensureThatArg(persistenceSession, is(not(nullValue())));
        ensureThatArg(transactionManager, is(not(nullValue())));
        
        transactionManager.injectInto(persistenceSession);

        
        // ... and finally return
        return persistenceSession;
	}


    /**
     * Creates the {@link NakedObjectTransactionManager}, potentially
     * overriddable.
     * 
     * <p>
     * Called from {@link #createPersistenceSession(PersistenceSessionFactory)}.
     */
    protected NakedObjectTransactionManager createTransactionManager(
            final NakedObjectConfiguration configuration,
            final AdapterManagerProxy adapterManager, 
            final PersistenceSessionTransactionManagement transactionManagement) {
        return new ClientSideTransactionManager(adapterManager, transactionManagement, getServerFacade(), getEncoder());
    }



}
// Copyright (c) Naked Objects Group Ltd.
