package org.nakedobjects.plugins.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ReferenceData;

public class ExecuteClientAction extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final ReferenceData[] data;
    private final int[] types;

    public ExecuteClientAction(final AuthenticationSession session, final ReferenceData[] data, final int[] types) {
        super(session);
        this.data = data;
        this.types = types;
    }

    public ExecuteClientAction(final ByteDecoder decoder) {
        super(decoder);
        int size = decoder.getInt();
        data = new ReferenceData[size];
        for (int i = 0; i < size; i++) {
            data[i] = (ReferenceData) decoder.getObject();
        }

        size = decoder.getInt();
        types = new int[size];
        for (int i = 0; i < size; i++) {
            types[i] = decoder.getInt();
        }
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {
        encoder.add(data.length);
        for (int i = 0; i < data.length; i++) {
            encoder.add(data[i]);
        }
        encoder.add(types);
        for (int i = 0; i < types.length; i++) {
            encoder.add(types[i]);
        }
    }

    public void execute(final ServerFacade distribution) {
        setResponse(distribution.executeClientAction(session, data, types));
    }

    public ClientActionResultData getActionResult() {
        return (ClientActionResultData) getResponse();
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("data", data.length);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
