package org.nakedobjects.plugins.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.query.data.PersistenceQueryData;

public class FindInstances extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final PersistenceQueryData criteria;

    public FindInstances(final AuthenticationSession session, final PersistenceQueryData criteria) {
        super(session);
        this.criteria = criteria;
    }

    public FindInstances(final ByteDecoder decoder) {
        super(decoder);
        criteria = (PersistenceQueryData) decoder.getObject();
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {
        encoder.add(criteria);
    }

    public void execute(final ServerFacade distribution) {
        final ObjectData[] instances = distribution.findInstances(session, criteria);
        setResponse(instances);
    }

    public ObjectData[] getInstances() {
        return (ObjectData[]) response;
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("criteria", criteria);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
