package org.nakedobjects.plugins.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;

public class OidForService extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String id;

    /**
     * provided for serialization only!
     */
    public OidForService() {
        super((AuthenticationSession) null);
        id = null;
    }

    public OidForService(final ByteDecoder decoder) {
        super(decoder);
        id = decoder.getString();
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {
        encoder.add(id);
    }

    public OidForService(final AuthenticationSession session, final String id) {
        super(session);
        this.id = id;
    }

    public void execute(final ServerFacade distribution) {
        response = distribution.oidForService(session, id);
    }

    public IdentityData getData() {
        return (IdentityData) response;
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("sequence", getId());
        str.append("id", id);
        return str.toString();
    }

}

// Copyright (c) Naked Objects Group Ltd.
