package org.nakedobjects.plugins.remoting.command.transport.pipe.client;

import org.nakedobjects.plugins.remoting.command.client.CommandClientConnection;
import org.nakedobjects.plugins.remoting.command.shared.requests.Request;
import org.nakedobjects.plugins.remoting.command.transport.pipe.shared.PipedConnection;
import org.nakedobjects.plugins.remoting.command.shared.requests.Response;


public class PipedClient implements CommandClientConnection {
    private PipedConnection communication;

    public void setConnection(final PipedConnection communication) {
        this.communication = communication;
    }

    public synchronized Response executeRemotely(final Request request) {
        communication.setRequest(request);
        return communication.getResponse();
    }

    public void init() {}

    public void shutdown() {}
}
// Copyright (c) Naked Objects Group Ltd.
