package org.nakedobjects.plugins.remoting.command.transport.pipe.shared;

import org.apache.log4j.Logger;
import org.nakedobjects.plugins.remoting.command.shared.requests.Request;
import org.nakedobjects.plugins.remoting.command.shared.requests.Response;


public class PipedConnection {
    private static final Logger LOG = Logger.getLogger(PipedConnection.class);
    private Request request;
    private Response response;
    private RuntimeException exception;

    public synchronized void setRequest(final Request request) {
        this.request = request;
        notify();
    }

    public synchronized Request getRequest() {
        while (request == null) {
            try {
                wait();
            } catch (final InterruptedException e) {
                LOG.error("wait (getRequest) interrupted", e);
            }
        }

        final Request r = request;
        request = null;
        notify();
        return r;
    }

    public synchronized void setResponse(final Response response) {
        this.response = response;
        notify();
    }

    public synchronized void setException(final RuntimeException exception) {
        this.exception = exception;
        notify();
    }

    public synchronized Response getResponse() {
        while (response == null && exception == null) {
            try {
                wait();
            } catch (final InterruptedException e) {
                LOG.error("wait (getResponse) interrupted", e);
            }
        }

        if (exception != null) {
            final RuntimeException toThrow = exception;
            exception = null;
            throw toThrow;
        }

        final Response r = response;
        response = null;
        notify();
        return r;
    }

}
// Copyright (c) Naked Objects Group Ltd.
