package org.nakedobjects.plugins.remoting.command.transport.socket.server;

import org.nakedobjects.plugins.remoting.command.shared.util.SharedUtil;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoderDefault;
import org.nakedobjects.runtime.installers.InstallerAbstract;
import org.nakedobjects.runtime.remoting.ServerListener;
import org.nakedobjects.runtime.remoting.ServerListenerInstaller;

public abstract class ServerListenerInstallerAbstract extends InstallerAbstract implements ServerListenerInstaller {

    protected abstract ServerListenerAbstract createListenerInstance();

    public ServerListener createListener() {

        final ServerListenerAbstract serverListener = createListenerInstance();
        ObjectEncoderDefault encoder = SharedUtil.createDefaultEncoderAndAddCriteriaStrategies(getConfiguration());
		serverListener.setEncoder(encoder);

        return serverListener;
    }

}
