package org.nakedobjects.plugins.remoting.shared.data;

import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.CollectionData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.NullData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ServerActionResultData;


/**
 * Create serializable objects that are used to carry messages across the network. This assumes that the Oid
 * and Version implementations are also serializable.
 */
public interface DataFactory {
    
    CollectionData createCollectionData(
            String collectionType,
            String elementType,
            Oid oid,
            ReferenceData[] elements,
            boolean hasAllElements,
            Version version);

    NullData createNullData(String type);

    ObjectData createObjectData(String type, Oid oid, boolean hasCompleteData, Version version);

    IdentityData createIdentityData(String type, Oid oid, Version version);

    ServerActionResultData createServerActionResultData(
            Data result,
            ObjectData[] updatesData,
            ReferenceData[] disposed,
            ObjectData persistedTarget,
            ObjectData[] persistedParameters,
            String[] messages,
            String[] warnings);

    ClientActionResultData createClientActionResultData(
            ReferenceData[] madePersistent,
            Version[] changedVersion,
            ObjectData[] updates);

    EncodeableObjectData createValueData(String fullName, String encodedValue);
}
// Copyright (c) Naked Objects Group Ltd.
