package org.nakedobjects.plugins.remoting.shared.encoding.object.data;

import java.io.Serializable;

import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;

public class ClientActionResultDataImpl implements ClientActionResultData, Encodable, Serializable {
    private static final long serialVersionUID = 1L;
    private final ReferenceData[] madePersistent;
    private final Version[] changedVersion;
    private final ObjectData[] updates;

    public ClientActionResultDataImpl(final ReferenceData[] madePersistent, final Version[] changedVersion, final ObjectData[] updates) {
        this.madePersistent = madePersistent;
        this.changedVersion = changedVersion;
        this.updates = updates;
    }

    public ClientActionResultDataImpl(final ByteDecoder decoder) {
        changedVersion = (Version[]) decoder.getObjects();
        madePersistent = (ObjectData[]) decoder.getObjects();
        updates = (ObjectData[]) decoder.getObjects();
    }

    public void encode(final ByteEncoder encoder) {
        encoder.add(changedVersion);
        encoder.add(madePersistent);
        encoder.add(updates);
    }

    public ReferenceData[] getPersisted() {
        return madePersistent;
    }

    public Version[] getChanged() {
        return changedVersion;
    }

    public ObjectData[] getUpdates() {
        return updates;
    }
}
// Copyright (c) Naked Objects Group Ltd.
