package org.nakedobjects.plugins.remoting.shared.encoding.object.data;

import java.io.Serializable;

import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;

public class NullDataImpl implements NullData, Encodable, Serializable {
    private static final long serialVersionUID = 1L;
    private final String type;

    public NullDataImpl(final String type) {
        this.type = type;
    }

    public NullDataImpl(final ByteDecoder decoder) {
        type = decoder.getString();
    }

    public void encode(final ByteEncoder encoder) {
        encoder.add(type);
    }

    public String getType() {
        return type;
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("type", type);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
